; K9 Mk. II: A protection and convienience script for mIRC
; Copyright (C) 1999  Nathan Roberts
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;
; To contact the author, send EMail to nathanr@crl.com, or see the web
; page at http://www.crl.com/~nathanr/k9.html

; K9 Channel Guarding Module
; **************************
; This module contains the channel guarding routines, and other
; channel protection stuff

; -------------------------------
; -- Channel guarding routines --
; -------------------------------

; -- To be moved into module A --
alias echon {
  echo $colour(notice) -at *** $1-
}

alias echoi {
  echo $colour(info) -at *** $1-
}

; -- Is channel protected? --
alias isprotect {
  if ($findtok(%k9.chans,$1,44) != $null) return $true
}

; -- Leave and rejoin
alias cycle {
  if ($1 == $null) {
    part $active
    quote join : $+ $active
  }
  else {
    part $1
    quote join : $+ $1
  }
}

; -- Detect limit --
raw 471:*:{
  if $isprotect($2) {
    echon Inviting you in
    inviteme $2
    master
  }
}

; -- Detect invite-only --
raw 473:*:{
  if $isprotect($2) {
    echon Inviting you in
    inviteme $2
    master
  }
}

; -- Detect ban --
raw 474:*:{
  if $isprotect($2) {
    echon Unbanning you
    inviteme $2
    unban $2
    master
  }
}

; -- Detect key --
raw 475:*:{
  if $isprotect($2) {
    echon Inviting you in
    inviteme $2
    master
  }
}

; -- Detect DALnet --
alias dalnet {
  if (*.dal.net iswm $server) return $true
}

; -- Chanserv Invite you to channel --
alias inviteme {
  chanserv invite $1
}

; -- Chanserv Unban you --
alias unban {
  chanserv unban $1 me
}

; -- Alias to mkick a channel --
alias mkick {
  chanserv mkick $1
}

; -- Alias to mdeop a channel --
alias mdeop {
  chanserv mdeop $1
}

; -- Alias to op yourself --
alias opme {
  if ($dalnet) {
    echoi Opping you
    if ($1 == $null) {
      chanserv op # $me
    }
    else {
      chanserv op $1 $me
    }
  }  
  else {
    echoi This command only works on DALnet
  }
}

; -- Manually deop everyone but you --
alias panic {
  echo $colour(notice) -t $chan *** Panic button activated
  %k9.foo = $opnick(0,#)
  :loop
  if ($opnick(%k9.foo,#) != $me) mode -o $opnick(%k9.foo,#)
  set %k9.foo %k9.foo - 1
  if %k9.foo > 0 goto loop
  unset %k9.foo
}

; -- Detect unban message from Chanserv --
on 1:notice:All bans on * for * have been cleared.:*:{
  if ($nick == ChanServ) && ($dalnet) {
    join $strip($4,b) %k9.kickchankey
  }
}

; -- Detect invite from Chanserv --
on 1:invite:#:{
  if ($nick == chanserv) && ($dalnet) {
    join $chan %k9.kickchankey
    opme $chan
  }
}

; -- If rejoining after kick, take offensive action --
; -- Autoboot check --
; -- Pervert check --
on 1:join:#:{
  if ($nick == %k9.norevenge) unset %k9.norevenge
  if ($nick == $me && $guardon) {
    if $isprotect($chan) {
      echo $colour(info) -t $chan *** I am guarding this channel
      unset %k9.norevenge
      if (%k9.kickchan != $null) {
        opme %k9.kickchan
        unset %k9.kickchan %k9.kickchankey
      }
    }
  }
  else if ($me isop $chan) {
    if (%k9.autobooton) {  
      set %k9.bar $gettok(%k9.autoboot,0,44)
      if (%k9.bar != 0) {
        set %k9.foo 0
        :loop
        inc %k9.foo
        if ($gettok(%k9.autoboot,%k9.foo,44) iswm $address($nick,5)) {
          ban $chan $nick 3
          kick $chan $nick Autoboot ( $+ $gettok(%k9.autoboot,%k9.foo,44) $+ )
          unset %k9.foo %k9.bar
          return
        }
        if (%k9.foo < %k9.bar) goto loop
      }
      unset %k9.foo
      unset %k9.bar
    }
    if (%k9.pervcheck) {  
      set %k9.pervnick $nick
      set %k9.pervchan $chan
      unset %k9.pervfound
      whois $nick
    }
  }
}

; -- Disabled to turn off channel guarding --
#k9.guard on

; -- Used to detect if this group is active --
alias guardon {
  return $true
}

; -- Unban you if you're opped --
on 1:ban:#:{
  if $isprotect($chan) && ($banmask iswm $address($me,5)) && ($me isop $chan) && ($me != $nick) {
    mode $chan -o-b $nick $banmask
    echon $nick banned you on $chan
    target $nick
    master
  }
}

; -- If reop after deop/kick, take offensive action --
on 1:op:#:{
  if ($opnick != $me) && ($nick == ChanServ) {
    set %k9.norevenge $opnick
  }
  else if (%k9.dop != $null) && ($opnick == $me) {
    if (%k9.dop != $me) {
      if (%k9.dop != %k9.norevenge && %k9.dop ison $chan) {
        mode $chan -o %k9.dop
        echon Enemy immobilized
        target %k9.dop
        master
      }
      else if (%k9.dop !ison $chan && %k9.dop != ChanServ) {
        echon %k9.dop has disappeared from the channel!
      }
      unset %k9.dop %k9.norevenge
    }
    unset %k9.dop
  }
}

; -- Detect deop --
on 1:deop:#:{
  if $isprotect($chan) && ($opnick == $me) && ($dalnet) {
    if ($nick == chanserv) {
      echon Chanserv deopped you.  Reidentifying.
      identify
      opme $chan
    }
    else {
      if ($nick == %k9.dop) chanserv deop $chan $nick
      set %k9.dop $nick
      opme $chan
      echon $nick deopped you on $chan $+ , taking offensive action
      master
    }
  }
  else if $isprotect($chan) && ($opnick != $me) && ($nick != $me) && (%k9.deopcheck) {
    if (%k9.deop.chan == $chan) && (%k9.deop.nick == $nick) {
      inc %k9.deop.count
      if (%k9.deop.count >= %k9.maxdeop) && ($me isop $chan) {
        echo mode -o $chan $nick
        mode $chan -o $nick
        echon Deopped $nick for mass-deopping
        target $nick
        unset %k9.deop.*
      }
    }
    else {
      set %k9.deop.chan $chan
      set %k9.deop.nick $nick
      set %k9.deop.count 1
      .timerk9deop 1 %k9.guardtime unset %k9.deop.*
    }
  }
}

; -- Make sure that K9 doesn't fail to take offensive action... --
; -- Track hostile's nick --
on 1:nick:{
  if ($nick == %k9.norevenge) unset %k9.norevenge
  if ($nick == %k9.pervfname) set %k9.pervfname $newnick
  if ($nick == %k9.dop) set %k9.dop $newnick
}

; -- Manually regain ops --
on 1:quit:{
  if ($nick == %k9.norevenge) unset %k9.norevenge
  set %foo 1
  if (%k9.regain) {
    :loop
    if ($me !isop $chan(%foo)) && ($nick($chan(%foo),0) == 2) && ($nick ison $chan(%foo)) && $isprotect($chan(%foo)) {
      cycle $chan(%foo)
    }
    inc %foo 1
    if (%foo <= $chan(0)) goto loop
    unset %foo
  }
}

on 1:part:#:{
  if ($nick == %k9.norevenge) unset %k9.norevenge
  if (%k9.regain) {
    if ($me !isop $chan) && ($nick($chan,0) == 2) && $isprotect($chan) {
      cycle $chan
    }
  }
}

; -- Detect kick --
on 1:kick:#:{
  if $isprotect($chan) && ($knick == $me) && ($dalnet) {
    if ($nick == %k9.dop) chanserv deop $chan $nick
    set %k9.dop $nick
    join $chan $chan($chan).key
    set %k9.kickchan $chan
    set %k9.kickchankey $chan($chan).key
    echon $nick kicked you from $chan $+ , taking offensive action
    master
  }
  else if $isprotect($chan) && ($knick != $me) && ($nick != $me) && (%k9.deopcheck) && (($knick isop $chan) || $lnot(%k9.onlyopkick)) {
    if (%k9.deop.chan == $chan) && (%k9.deop.nick == $nick) {
      inc %k9.deop.count
      if (%k9.deop.count >= %k9.maxkick) && ($me isop $chan) {
        mode $chan -o $nick
        echon Deopped $nick for mass-kicking
        target $nick
        unset %k9.deop.*
      }
    }
    else {
      set %k9.deop.chan $chan
      set %k9.deop.nick $nick
      set %k9.deop.count 1
      .timerk9deop 1 %k9.guardtime unset %k9.deop.*
    }
  }
}

; -- Nethack protection --

on 1:serverop:#:{
  if $isprotect($chan) && (%k9.nethack) && ($opnick != $me) {
    mode $chan -o $opnick
  }
}

#k9.guard end

; --------------------
; -- Pervert pieces --
; --------------------

; -- Listen for Whois events and check for perverts --
raw 311:*:{
  if ($2 == %k9.pervnick) {
    checkperv n $2 $6-
  }
}

raw 319:*:{
  if ($2 == %k9.pervnick) {
    checkperv c $3-
  }
}

alias checkperv {
  set %k9.foo 1
  :pvckloop
  if (%k9.foo <= $gettok(%k9.pervwords,0,44)) && ($lnot(%k9.pervfound)) {
    if ($gettok(%k9.pervwords,%k9.foo,44) isin $2-) {
      if ( $1 == c ) {
        foundperv %k9.pervnick %k9.pervchan %k9.pervwav Pervert detected entering %k9.pervchan $+ : %k9.pervnick $+ /Pervert detected/ $+ %k9.pervnick on: $2-
      }
      else if ( $1 == n ) {
        foundperv %k9.pervnick %k9.pervchan %k9.pervwav Pervert detected entering %k9.pervchan $+ : %k9.pervnick $+ /Pervert detected/ $+ %k9.pervnick is: $3-
      }
    }
    set %k9.foo %k9.foo + 1
    goto pvckloop
  }
  unset %k9.foo
}  

raw 318:*:{
  unset %k9.pervfound
}

; -- Found pervert --
alias foundperv {
  set %k9.pervfname $1
  set %k9.pervfchan $2
  if ($exists($3)) splay $3
  echon $gettok($4-,1,47)
  if ($gettok($4-,0,47) >= 3) echon $gettok($4-,3-,47)
  echon Press F10 to terminate this person
  set %k9.pervfound $true
  set %k9.pervreason $gettok($4-,2,47)
}

; -- Listen for bad words --
; -- Listen for flooding --
on 1:text:*:#:{
  if ($nick !isop $chan) && ($me isop $chan) {
    if (%k9.badwordcheck)  {
      set %k9.foo $gettok(%k9.badwords,0,44)
      if (%k9.foo == 0) return
      :loop
      if ($gettok(%k9.badwords,%k9.foo,44) isin $1-) {
        foundperv $nick $chan %k9.badwwav Bad word said by $nick on $chan $+ /Bad word detected
        return
      }
      dec %k9.foo
      if (%k9.foo > 0) goto loop
    }
    if (%k9.targetflood) {
      if (%k9.cflood.nick != $nick) {
        set %k9.cflood.nick $nick
        set %k9.cflood.lines 1
        .timerk9cflood 1 %k9.cfloodtime unset %k9.cflood.*
      }
      else {
        inc %k9.cflood.lines
        if (%k9.cflood.lines >= %k9.cfloodlines) {
          .timerk9cflood off
          foundperv $nick $chan %k9.badwwav Flooding by $nick on $chan $+ /Flood
          unset %k9.cflood.*
        }
      }
    }
  }
}  

; -- Kill pervert --
alias killperv {
  if (%k9.pervfname != $null) {
    terminate %k9.pervfname %k9.pervreason
    unset %k9.pervfname %k9.pervfchan %k9.pervfound %k9.pervreason
  }
}

; -- Autokick alias --
alias autokick {
  if ($1 == $null) {
    k9akickd
  }
  else if ($1 == -r) {
    set %k9.autoboot $remtok(%k9.autoboot,$2,44)
    echoi Removed $2 from autokick list
  }
  else {
    set %k9.autoboot $addtok(%k9.autoboot,$1,44)
    echoi Added $1 to autokick list
  }
}

; -- Target alias --
alias target {
  if ($1 == $null) {
    echoi Target command: Targets a user for kicking
    echoi Syntax: /TARGET nick [reason]
    halt
  }
  set %k9.pervfname $1
  set %k9.pervfound $true
  set %k9.pervreason $2-
  echon $1 targeted.  Press F10 to boot
}

; -- Slam alias --
alias slam {
  if ($address($1,3) == $null) {
    echon Cannot slam $1
  }
  else {
    terminate $1 $2-
    autokick $address($1,3)
  }
}

; -----------------------------------------------
; -- Stuff for the Channel Settings/Info menus --
; -----------------------------------------------

alias modeon {
  if ($chan($1).mode != $null) && ($2 isin $gettok($chan($1).mode,1,32)) return $true
}

alias setno {
  if ($modeon($1,$2)) {
    return (Set)
  }
  else {
    return (Not set)
  }
}

alias togmode {
  if ($modeon($1,$2)) {
    if ($2 == k) {
      mode $1 -k $chan($1).key
    }
    else {
      mode $1 - $+ $2
    }
  }
  else {
    if ($3 != $null) {
      mode $1 + $+ $2 $?="Enter parameter"
    }
    else {
      mode $1 + $+ $2
    }
  }
}

alias showbans {
  set %showbans $1
  unset %foundbans
  mode $1 +b
}

alias banclear {
  set %banclear $1
  mode $1 +b
}

raw 367:*:{
  if ($2 == %showbans) {
    if (%foundbans == $null) {
      echo $colour(info) -t $2 *** Bans for $2 $+ :
      set %foundbans $true
    }
    echo $colour(info) -t $2 *** $3 ( $+ $4, $asctime($5) $+ )
    halt 
  }
  if ($2 == %banclear) {
    set %banclearbans %banclearbans $3
    if ($gettok(%banclearbans,0,32) == 3) {
      mode $2 -bbb %banclearbans
      unset %banclearbans
    }
    halt
  }
}

raw 368:*:{
  if ($2 == %showbans) {
    if (%foundbans == $null) {
      echo $colour(info) -t $2 *** No bans set for $2
    }
    else {
      echo $colour(info) -t $2 *** End of list
    }
    unset %showbans
    halt
  } 
  if ($2 == %banclear) {
    unset %banclear
    if (%banclearbans != $null) {
      mode $2 -bbb %banclearbans
      unset %banclearbans
    }
    halt
  }
}


; -------------------
; -- Function Keys --
; -------------------

; -- F11: Op yourself --
alias f11 {
  opme
}

; -- Ctrl-F12: Panic! --
alias cf12 {
  if (%k9.panic) panic
}

; -- F10: Kill pervert function key --
alias f10 {
  killperv
}
