; K9 Mk. II: A protection and convienience script for mIRC
; Copyright (C) 1999  Nathan Roberts
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;
; To contact the author, send EMail to nathanr@crl.com, or see the web
; page at http://www.crl.com/~nathanr/k9.html

; --[ Channel info ]----------------

dialog k9cinfo {
  title "Channel Info"
  size   -1 -1 410 230

  button "Ok", 1, 360 210 050 020, ok, default
  ;  button "&Help", 100, 210 160 050 020

  text "Founder:", 2, 15 12 80 15, right
  text "Mode Lock:", 3, 15 32 80 15, right
  text "Last Topic:", 4, 15 52 80 15, right
  text "Description:", 5, 15 72 80 15, right
  text "URL:", 6, 15 92 80 15, right
  text "Options:", 7, 15 112 80 15, right
  text "Memo Level:", 8, 15 132 80 15, right
  text "Registered:", 9, 15 152 80 15, right
  text "Last Opping:", 10, 15 172 80 15, right
  edit "", 52, 105 10 295 20, read, autohs
  edit "", 53, 105 30 295 20, read, autohs
  edit "", 54, 105 50 295 20, read, autohs
  edit "", 55, 105 70 295 20, read, autohs
  edit "", 56, 105 90 295 20, read, autohs
  edit "", 57, 105 110 295 20, read, autohs
  edit "", 58, 105 130 295 20, read, autohs
  edit "", 59, 105 150 295 20, read, autohs
  edit "", 60, 105 170 295 20, read, autohs
}



; --[ Nick info ]----------------

dialog k9ninfo {
  title "Nick Info"
  size   -1 -1 410 350

  button "Ok", 1, 360 330 050 020, ok, default
  ;  button "&Help", 100, 210 160 050 020


  text "Nickname:", 2, 15 12 80 15, right
  text "Full Name:", 3, 15 32 80 15, right
  text "Mask:", 4, 15 52 80 15, right
  text "Channels:", 5, 15 72 80 15, right
  text "Server:", 6, 15 92 80 15, right
  text "IRCop:", 7, 15 112 80 15, right
  text "Signon:", 8, 15 132 80 15, right
  text "Idle:", 9, 15 152 80 15, right
  text "Away:", 10, 15 172 80 15, right
  text "URL:", 11, 15 192 80 15, right
  text "Nick Kill:", 12, 15 212 80 15, right
  text "Last address:", 13, 15 232 80 15, right
  text "Last seen:", 14, 15 252 80 15, right
  text "Registered:", 15, 15 272 80 15, right
  text "Time Now:", 16, 15 292 80 15, right
  edit "", 52, 105 10 295 20, read, autohs
  edit "", 53, 105 30 295 20, read, autohs
  edit "", 54, 105 50 295 20, read, autohs
  edit "", 55, 105 70 295 20, read, autohs
  edit "", 56, 105 90 295 20, read, autohs
  edit "", 57, 105 110 295 20, read, autohs
  edit "", 58, 105 130 295 20, read, autohs
  edit "", 59, 105 150 295 20, read, autohs
  edit "", 60, 105 170 295 20, read, autohs
  edit "", 61, 105 190 295 20, read, autohs
  edit "", 62, 105 210 295 20, read, autohs
  edit "", 63, 105 230 295 20, read, autohs
  edit "", 64, 105 250 295 20, read, autohs
  edit "", 65, 105 270 295 20, read, autohs
  edit "", 66, 105 290 295 20, read, autohs
}


; --[ Op list ]----------------

dialog k9oplist {
  size   -1 -1 410 350
  Title  "Retrieving data..."

  button "Ok", 1, 360 330 050 020, ok, default


  list 2, 15 15 380 250, sort
  edit "", 3, 15 255 380 20

  button "&Add", 10, 295 275 50 20, disabled
  button "&Remove", 11, 345 275 50 20, disabled
}

on 1:dialog:k9oplist:sclick:2:handleselect $dname 3 2 10 11
on 1:dialog:k9oplist:edit:3:{
  handleedit $dname 3 10
  did -f k9oplist 3
}

on 1:dialog:k9oplist:dclick:2:{
  if (?op* iswm $dialog(k9oplist).title) {
    info $gettok($did(k9oplist,2,$did(k9oplist,2).sel),1,32)
  }
}

on 1:dialog:k9oplist:sclick:10:{
  if (Access* iswm $dialog(k9oplist).title) {
    nickserv access add $did(k9oplist,3,1)
  }
  else {
    chanserv $gettok($dialog(k9oplist).title,1,32) $gettok($dialog(k9oplist).title,4,32) add $did(k9oplist,3,1)
  }
  handleadd k9oplist 2 3
}
on 1:dialog:k9oplist:sclick:11:{
  if (Access* iswm $dialog(k9oplist).title) {
    nickserv access del $did(k9oplist,3,1)
  }
  else {
    chanserv $gettok($dialog(k9oplist).title,1,32) $gettok($dialog(k9oplist).title,4,32) del $gettok($did(k9oplist,2,$did(k9oplist,2).sel),1,32)
  }
  handledel k9oplist 2 3 10 11
}

; --[ Away list ]----------------

dialog k9awaylist {
  size   -1 -1 410 350

  button "Ok", 1, 360 330 050 020, ok, default


  combo 2, 15 15 380 250, sort

  button  "&Add", 40, 310 275 050 020, disabled
  button  "&Delete", 41, 360 275 050 020, disabled
}

on 1:dialog:k9awaylist:sclick:2:handleselect k9awaylist 2 2 40 41
on 1:dialog:k9awaylist:edit:2:handleedit k9awaylist 02 40
on 1:dialog:k9awaylist:sclick:40:handleadd k9awaylist 2 2
on 1:dialog:k9awaylist:sclick:41:handledel k9awaylist 2 2 40 41

on 1:dialog:k9awaylist:init:0:{
  if (%k9.aqfunc == away)  {
    loadlist k9awaylist 2 126 %k9.awaymsg
  }
  else {
    loadlist k9awaylist 2 126 %k9.quitmsg
  }
  did -f k9awaylist 2
  unset %k9.aqfunc
}

on 1:dialog:k9awaylist:dclick:2:{
  dialog -k k9awaylist
}

on 1:dialog:k9awaylist:sclick:1:{
  if (Away* iswm $dialog(k9awaylist).title) {
    makeaway $did(k9awaylist,2,0)
    set %k9.awaymsg $getlist(k9awaylist,2,126)
  }
  else {
    makequit $did(k9awaylist,2,0)
    set %k9.quitmsg $getlist(k9awaylist,2,126)
  }
}

; --[ About box ]----------------

dialog k9about {
  title "About K9"
  size   -1 -1 310 145

  icon     50, 10 10 32 32

  text     "", 51, 50 10 290 15
  text     "Copyright 1999 Nathan Roberts", 52, 50 25 290 15

  text     "K9 Mk. II comes with ABSOLUTELY NO WARRANTY.  This is free software, and you are welcome to redistribute it under certain conditions.  See the file COPYING for details.", 53, 10 45 290 90

  text     "Check out the web page at http://www.crl.com/~nathanr/k9.html", 54, 10 95 290 30

  button  "&Documentation" 2, 160 125 100 20
  button  "Ok" 1, 260 125 50 20,default,ok
}

on 1:dialog:k9about:sclick:50:master
on 1:dialog:k9about:sclick:2:run $scriptdir $+ k9.htm

; on 1:dialog:k9about:sclick:100:k9helpd Main K9 Setup

on 1:dialog:k9about:init:0:{
  did -a k9about 51 K9 Mk. II $k9versionno
  if ($exists($scriptdirk9.ico)) did -g k9about 50 $scriptdirk9.ico
}

alias k9about {
  redialog -m k9about k9about
}

; --[ Memoserv frontend ]----------------------

on 1:notice:Memo list for*:*:{
  if ($nick != memoserv) return
  if ($dialog(memolist)) dialog -x memolist
  dialog -m memolist memolist
  set %k9.memolist 1
}

on 1:notice:End of memo list*:*:{
  if ($nick != memoserv) return
  unset %k9.memolist
}

on 1:notice:Memo * from*:*:{
  did -r memolist 11
  set %k9.memotext 1
}

on 1:notice:Memo has been sent to user*:*:{
  if ($nick != memoserv) return
  if ($dialog(sendmemo)) dialog -x sendmemo
}

on 1:notice:*:*:{
  if ($nick != memoserv) return

  if ($dialog(memolist) == $null) {
    unset $k9.memolist %k9.memotext
    return
  }
  if (%k9.memolist) {
    did -a memolist 10 $1 $+ . $2 $+ , $3-
  }
  else if (%k9.memotext) {
    did -a memolist 11 $1-
    unset %k9.memotext
  }
}

dialog memolist {
  title "Memo List"
  size   -1 -1 300 350

  text "Memo List:", 20, 0, 0, 300, 15
  list 10, 0, 15, 300, 100
  text "Memo:", 21, 0, 115, 300, 15
  edit "" 11, 0, 130, 300, 200, read, multi
  button "Ok", 1, 250, 330, 50, 20, ok
  button "&Read", 2, 0, 330, 50, 20, default
  button "Re&ply", 5, 50, 330, 50, 20
  button "&Delete", 3, 100, 330, 50, 20
  button "&Purge", 4, 150, 330, 50, 20
}

on 1:dialog:memolist:sclick:2:{
  readmemo
}

on 1:dialog:memolist:dclick:10:{
  readmemo
}

on 1:dialog:memolist:sclick:3:{
  delmemo
}

on 1:dialog:memolist:sclick:4:{
  purgememo
}

on 1:dialog:memolist:sclick:5:{
  replymemo
}

on 1:dialog:memolist:sclick:10:{
  did -r memolist 11
}

alias -l readmemo {
  var %num 

  did -a memolist 11 Retrieving memo...
  set %num $did(memolist,10,1).sel
  if (%num == $null) return
  memoserv read %num
}

alias -l delmemo {
  var %num 
  set %num $did(memolist,10,1).sel
  if (%num == $null) return
  memoserv del %num
  did -o memolist 10 %num D $+ $did(memolist,10,%num)
  did -r memolist 11
}

alias -l purgememo {
  var %i

  %i = 1
  while ($did(memolist,10,%i) != $null) {
    if (D* iswm $did(memolist,10,%i)) {
      did -d memolist 10 %i
    }
    else {
      inc %i
    }
  }
  memoserv purge
}

alias -l replymemo {
  var %num, %text, %name
  set %num $did(memolist,10,1).sel
  if (%num == $null) return

  %text = $did(memolist,10,%num)
  %name = $gettok($gettok(%text,1,44),2,32)
  sendmemo %name
}

alias memolist {
  memoserv list
}

alias sendmemo {
  if ($dialog(sendmemo)) dialog -x sendmemo
  dialog -m sendmemo sendmemo
  if ($1 != $null) {
    did -a sendmemo 10 $1-
    did -f sendmemo 11
  }
}

dialog sendmemo {
  title "Send memo"
  size   -1 -1 300 290

  box "&Destination", 50, 0, 0, 300, 60
  text "Send to:", 20, 5, 15, 100, 15
  edit "" 10, 105, 15, 190, 20
  check "Send to &SOPs", 21, 105, 35, 190, 20

  box "&Message", 51, 0, 60, 300, 200
  edit "" 11, 5, 75, 290, 180, multi

  button "Cancel", 1, 0, 270, 50, 20, cancel
  button "&Send", 2, 250, 270, 50, 20, default
}

on 1:dialog:sendmemo:sclick:2:{
  if ($did(sendmemo,10,1) == $null) {
    echon You must enter a reciepiant
    return
  }
  if ($did(sendmemo,11,1) == $null) {
    echon You must enter a message
    return
  }

  var %command, %recip, %message
  if ($did(sendmemo,21).state) {
    %command = sendsop
  }
  else {
    %command = send
  }

  %recip = $did(sendmemo,10,1)
  %message = $did(sendmemo,11,1)

  echon Sending message...
  memoserv %command %recip %message
}
