; K9 Mk. II: A protection and convienience script for mIRC
; Copyright (C) 1999  Nathan Roberts
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;
; To contact the author, send EMail to nathanr@crl.com, or see the web
; page at http://www.crl.com/~nathanr/k9.html

; K9 Channel Functions Module
; ***************************
; This module contains the functions for the functions K9 offers.
; Specifically, the sound harvester and event sound systems,
; and the DCC partyline

; ---------------------
; -- Sound harvester --
; ---------------------

; -- Sound list alias --
alias sl {
  set %foo $wavedir $+ *.wav
  set %foo $dir %foo
  if ( %foo != $null ) sound %foo
  unset %foo
}

; -- Silence sound/sound list --
alias silsl {
  if ($inwave) || ($inmidi) {
    splay stop
  }
  else {
    sl
  }
}

; -- Show sound name in channel --
; -- Set name of last played WAV --
ctcp 1:sound:{
  set %k9.wavnick $nick
  set %k9.wavfile $2
  if (%k9.showsound) {
    if ($chan == $null) {
      echo $colour(info) -t $nick [SOUND] $2
    }
    else {
      echo $colour(info) -t $chan [SOUND] $2
    }
  }
}

; -- Grab WAV --
alias wavgrab {
  if (%k9.wavnick != $null) && (%k9.wavfile != $null) msg %k9.wavnick ! $+ %k9.wavnick %k9.wavfile
}

; -- Toggle auto-grab --
alias togagrab {
  set %k9.autograb $lnot(%k9.autograb)
  if ( $1 != -q ) echo $colour(info) -at *** Auto-grab $endis(%k9.autograb)
}

; -- Play last grab --
alias playlastgrab {
  if (%k9.lastgrabwav != $null) {
    splay %k9.lastgrabwav
  }
}

; -- Listen for non-existant sounds for auto-grab --
on 1:nosound:{
  if (%k9.autograb) {
    echon Don't have $filename $+ : Autograbbing
    msg $nick ! $+ $nick $filename
  }
}

on 1:filercvd:*.wav:{
  set %k9.lastgrabwav $filename
  if (%k9.playlastgrab) playlastgrab
}

on 1:filercvd:*.mid:{
  set %k9.lastgrabwav $filename
  if (%k9.playlastgrab) playlastgrab
}

ctcp 1:dcc:{
  if ($2 == send) && ((*.wav iswm $3) || (*.mid iswm $3)) && (%k9.autoaccept) && ($sreq != auto) {
    .timer 1 1 .sreq $sreq
    .sreq auto
    .sreq +m
  }
}

; ------------------
; -- Event sounds --
; ------------------

; -- Toggle event sounds --
alias togglees {
  if ( %k9.eventsounds ) {
    set %k9.eventsounds $false
    if ( $1 != q ) echo $colour(info) -at *** Event sounds off
  }
  else {
    set %k9.eventsounds $true
    if ( $1 != q ) echo $colour(info) -at *** Event sounds on
  }
}

; -- Play the given sound --
alias mfplay {
  if (%k9.eventsounds) {
    if ($1 != $null) {
      if ($inwave) {
        if (%k9.lastev != $1 ) splay -q $1
      }
      else {
        splay $1
      }
    }
    set %k9.lastev $1
  }
}

; -- Event sound and nick recovery events --

on 1:connect:mfplay %k9.sound.connect
on 1:join:#:mfplay %k9.sound.join
on 1:part:#:mfplay %k9.sound.part
on 1:action:*:*:mfplay %k9.sound.action
on 1:nick:{
  mfplay %k9.sound.nickchange
  if ($nick == $me) && ($newnick == %k9.recover) {
    unset %k9.recover
    .notify -r $nick
  }
}
on 1:topic:#:mfplay %k9.sound.topicchange
on 1:notify:if ($lnot($inwave)) mfplay %k9.sound.notify
on 1:unotify:{
  mfplay %k9.sound.notifyoff
  if ($nick == %k9.recover) {
    nick $nick
    unset %k9.recover
    .notify -r $nick
  }
}
on 1:op:#:{
  if ( $opnick == $me ) {
    mfplay %k9.sound.opme
  }
  else {
    mfplay %k9.sound.op
  }
}
on 1:deop:#:{
  if ( $opnick == $me ) {
    mfplay %k9.sound.deopme
  }
  else {
    mfplay %k9.sound.deop
  }
}
on 1:kick:#:{
  if ( $knick == $me ) {
    mfplay %k9.sound.kickme
  }
  else {
    mfplay %k9.sound.kick
  }
}
on 1:invite:#:mfplay %k9.sound.invite
on 1:open:?:mfplay %k9.sound.message
on 1:notice:*:*:if ($lnot($inwave)) mfplay %k9.sound.notice
on 1:quit:mfplay %k9.sound.quit
ctcp 1:ping:mfplay %k9.sound.ping

; ----------------
; -- Party Line --
; ----------------

#k9party on

alias party {
  if ( $1 == $null ) {
    if (%party == $null) {
      echo $colour(info) -at *** Partyline is not active
    }
    else {
      echo $colour(info) -at *** Partyline members: %party
    }
    return
  }
  if ( $chat($1) == $null ) {
    dcc chat $1
    set %party.request $addtok(%party.request,$1,44)
  }
  else {
    set %party $addtok(%party,$1,44)
    partymsg . *** $1 has joined the party line
    partycmd $1 whom
    msg = $+ $1 *** Type .help for commands
  }
}

alias unparty {
  if ($isparty($1)) {
    if ( $2 == -n ) {
      if ( $3 != $null ) {
        partymsg $1 *** $1 has left the party line ( $+ $3- $+ )
      }
      else {
        partymsg $1 *** $1 has left the party line
      }
    }
    else {
      if ( $2 != $null ) {
        partymsg . *** $1 has left the party line ( $+ $2- $+ )
      }
      else {
        partymsg . *** $1 has left the party line
      }
    }
    set %party $remtok(%party,$1,44) 
  }
}

alias endparty {
  if ( $1 == $null ) {
    partymsg . *** Party line shut down
  }
  else {
    partymsg . *** Party line shut down ( $+ $1- $+ )
  }
  unset %party
}

alias partymsg {
  if ( %party == $null ) return
  set %party.foo 1
  :loop
  if ( $gettok(%party,%party.foo,44) != $1 ) {
    if ( $chat($gettok(%party,%party.foo,44)) != $null ) msg = $+ $gettok(%party,%party.foo,44) $2-
  }
  inc %party.foo
  if ( %party.foo <= $gettok(%party,0,44) ) goto loop
  unset %party.foo
}

; on 1:chatopen:{
on 1:open:=:{
  if ($findtok(%party.request,$nick,44) != $null) {
    set %party.request $remtok(%party.request,$nick,44)
    party $nick
  }
}

; on 1:chatclose:{
on 1:close:=:{
  unparty $nick -n
}

alias isparty {
  if ($findtok(%party,$1,44) != $null) return $true
}

on 1:chat:*:{
  if ($isparty($nick)) {
    if ($1 == $chr(1) $+ ACTION) {
      partymsg $nick * $nick $2-
    }
    else if ($asc($left($1,1)) != 46) {
      partymsg $nick < $+ $nick $+ > $1-
    }
    else {
      partycmd $nick $mid($1,2,255) $2-
    }
  }
}

on 1:input:*:{
  if ($left($active,1) == =) {
    set %party.foo $mid($active,2,255)
    if ($isparty(%party.foo)) {
      if ($asc($left($1,1)) == 47) {
        if ( $1 == /ME ) {
          partymsg %party.foo $chr(1) $+ ACTION $2-
        }
        return
      }
      else if ($asc($left($1,1)) != 46) {
        partymsg %party.foo $1-
      }
      else {
        partycmd -a $mid($1,2,255) $2-
        halt
      }
    }
  }
}

alias partycmd {
  if ( $2 == whom ) {
    set %party.users $gettok(%party,1,44)
    set %party.user 2
    :loop
    if ( $gettok(%party,%party.user,44) != $null ) {
      set %party.users %party.users $+ , $gettok(%party,%party.user,44)
      inc %party.user
      goto loop
    }
    partycmdmsg $1 *** Current Partyline users: %party.users
  }
  else if ( $2 == msg ) {
    if ( $isparty($3) ) {
      if ( $1 != -a ) {
        msg = $+ $3 - $+ $1 $+ - $4-
      }
      else {
        msg = $+ $3 -Host- $4-
      }
    }
    else if ( $3 == host ) {
      echo -at *** - $+ $1 $+ - $4-
    }
    else {
      partycmdmsg $1 *** User not on partyline
    }
  }
  else if ( $2 == quit ) {
    if ( $1 != -a ) {
      unparty $1
    }
    else {
      endparty
    }
  }
  else if ( $2 == help ) {
    partycmdmsg $1 *** Available commands:
    partycmdmsg $1 *** .whom ............. Show who is on the party line
    partycmdmsg $1 *** .msg nick message . Sends private message
    partycmdmsg $1 *** .quit ............. Leave the party line
  }
  else {
    partycmdmsg $1 *** Unknown command
  }
}

alias partycmdmsg {
  if ( $1 == -a ) {
    echo $1-
  }
  else {
    msg = $+ $1 $2-
  }
}


on 1:start:{
  unset %party
  unset %party.*
}

#k9party end

; -----------------------
; -- Server of the Day --
; -----------------------

alias sotd {
  unset %k9.sotd.*
  set %k9.sotd.channel $active
  set %k9.sotd.number 1
  set %k9.sotd.nick $nick($active,1)
  whois %k9.sotd.nick
}

raw 312:*:{
  if ($2 != %k9.sotd.nick) return
  set %k9.sotd.svnumber $findtok(%k9.sotd.servers,$3,1,32) 
  if (%k9.sotd.svnumber == $null) {
    set %k9.sotd.servers %k9.sotd.servers $3
    set %k9.sotd.svcount %k9.sotd.svcount 1
  }
  else {
    set %k9.sotd.svcount $puttok(%k9.sotd.svcount,$calc($gettok(%k9.sotd.svcount,%k9.sotd.svnumber,32) + 1),%k9.sotd.svnumber,32)
  }
  inc %k9.sotd.number
  set %k9.sotd.nick $nick(%k9.sotd.channel,%k9.sotd.number)
  if (%k9.sotd.nick != $null) {
    whois %k9.sotd.nick
  }
  else {
    showsotd
  }
}

raw 401:*:{
  if (%k9.sotd.channel) {
    set %k9.sotd.nick $nick(%k9.sotd.channel,%k9.sotd.number)
    if (%k9.sotd.nick != $null) {
      whois %k9.sotd.nick
    }
    else {
      showsotd
    }
  }
}

alias showsotd {
  set %k9.foo 1
  echo $colour(notice) -t %k9.sotd.channel [-- Server usage stats for %k9.sotd.channel --]
  :loop
  if ($gettok(%k9.sotd.svcount,%k9.foo,32) != 1) {
    echo $colour(info) -t %k9.sotd.channel --> $gettok(%k9.sotd.svcount,%k9.foo,32) users on $gettok(%k9.sotd.servers,%k9.foo,32)
  }
  else {
    inc %k9.sotd.singles
  }
  inc %k9.foo
  if ($gettok(%k9.sotd.svcount,%k9.foo,32) != $null) goto loop
  if (%k9.sotd.singles != $null) {
    echo $colour(info) -t %k9.sotd.channel --> %k9.sotd.singles servers with only 1 user
  }    
  unset %k9.foo %k9.sotd.*
}

; --------------------------
; -- Manual nick recovery --
; --------------------------

alias recover {
  if (%k9.recover == $null) && (($1 == $null) || ($1 == -n)) {
    echo 3 -a *** Not currently trying to recover any nick
  }
  else if ($1 == $null) {
    echo 3 -a *** Currently waiting to recover %k9.recover
    echo 3 -a *** Type /RECOVER -n to stop
  }
  else if ($1 == -n) {
    echo 3 -a *** Stopped waiting for %k9.recover
    .notify -r %k9.recover
    unset %k9.recover
  }
  else {
    if (%k9.recover != $null) .notify -r %k9.recover
    set %k9.recover $1
    .notify $1
    nick $1
    echo 3 -a *** Now waiting for %k9.recover
  }
}


; -------------------
; -- Function Keys --
; -------------------

; -- F4: Grab WAV --
alias f4 {
  wavgrab
}

; -- Shift-F4: Toggle autograb --
alias sf4 {
  togagrab
}

; -- F2: Show sound list --
alias f2 {
  silsl
}

; -- Ctrl-F2: Play last grab --
alias cf2 {
  playlastgrab
}

; -- F9: Toggle event sounds --
alias f9 {
  togglees
}
