; K9 Mk. II: A protection and convienience script for mIRC
; Copyright (C) 1999  Nathan Roberts
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;
; To contact the author, send EMail to nathanr@crl.com, or see the web
; page at http://www.crl.com/~nathanr/k9.html

alias mircmenus.version {
  return 3
}

alias onoff {
  if ( $1 ) return On
  return Off
}

alias yesno {
  if ( $1 ) return Yes
  return No
}

alias endis {
  if ( $1 ) return enabled
  return disabled
}

alias lnot {
  if ( $1 ) return 0
  return 1
}

;Current:
;menu.createmenu title x y w h { firstitem | -C delimeter collection | -E popup var delimeter collection }
;menu.createitem ...
;menu.addcollection delimeter collection

alias menu.createmenu {
  if ( $window($1).state == $null ) {
    unset %menu.windowitem
    if ( $6 == -E ) {
      window -l $1 $2-5 $7
    }
    else {
      window -l $1 $2-5 $1
    }
    set %menu.windowsel $true
  }
  else {
    set %menu.windowitem 1
    unset %menu.windowsel
  }
  set %menu.windowname $1
  if ( $6 != $null ) {
    if ( $6 == -C ) {
      menu.addcollection $7 $8-
    }
    else if ( $6 == -E ) {
      menu.addcollection $9 $10-
      set %menu.var $8
      set %menu.items $10-
      set %menu.sep $9
      if ( $noitems ) aline %menu.windowname Press Space Bar or right mouse button to add items
    }
    else {
      menu.createitem $6-
    }
  }
}

alias menu.createitem {
  if ( %menu.windowitem == $null ) {
    aline %menu.windowname $1-
    if %menu.windowsel {
      sline %menu.windowname 1
      unset %menu.windowsel
    }
  }
  else {
    if ( $sline(%menu.windowname,1).ln == %menu.windowitem ) set %menu.windowsel $true
    rline %menu.windowname %menu.windowitem $1-
    if ( %menu.windowsel ) { 
      sline %menu.windowname %menu.windowitem
      unset %menu.windowsel 
    }
    inc %menu.windowitem
  }
}

alias menu.addcollection {
  if ( $2 == $null ) return
  set %menu.foo 1
  set %menu.bar $gettok($2-,0,$1)
  :loop
  menu.createitem $gettok($2-,%menu.foo,$1)
  if ( %menu.foo < %menu.bar ) {
    inc %menu.foo
    goto loop
  }
}

alias noitems {
  if ( $gettok(%menu.items,0,%menu.sep) == 0 ) || ( $gettok(%menu.items,0,%menu.sep) == $null ) {
    return $true
  }
  else {
    return $false
  }
}

alias menu.edititem {
  if ( $noitems == $false ) {
    set %menu.foo $?="Enter new value for this item:"
    if ( %menu.foo != $null ) && ( $findtok(%menu.items,%menu.foo,%menu.sep) == $null ) {
      rline -s %menu.windowname $1 %menu.foo
      set %menu.items $reptok(%menu.items,$gettok(%menu.items,$1,%menu.sep),%menu.foo,%menu.sep)
      unset %menu.foo
      set % $+ %menu.var %menu.items
    }
  }
}

alias menu.additem {
  set %menu.foo $?="Enter item to add:"
  if ( %menu.foo != $null ) && ( $findtok(%menu.items,%menu.foo,%menu.sep) == $null ) {
    if ( $noitems ) dline %menu.windowname 1
    aline -s %menu.windowname %menu.foo
    set %menu.items $addtok(%menu.items,%menu.foo,%menu.sep)
    unset %menu.foo
    set % $+ %menu.var %menu.items
  }
}

alias menu.delitem {
  if ( $noitems == $false ) {
    dline %menu.windowname $1
    set %menu.items $remtok(%menu.items,$gettok(%menu.items,$1,%menu.sep),%menu.sep)
    set % $+ %menu.var %menu.items
    if ( $noitems ) aline -s %menu.windowname No items; press Space Bar or right mouse button to add
  }
}

alias menu.moveitem {
  if ($noitems) || ($gettok(%menu.items,0,%menu.sep) == 1) return
  iline %menu.windowname 1 $line(%menu.windowname,$1)
  dline %menu.windowname $1
  set %menu.items $remtok(%menu.items,$gettok(%menu.items,$1,%menu.sep),%menu.sep)
  set % $+ %menu.var %menu.items
  if ( $noitems ) aline -s %menu.windowname No items; press Space Bar or right mouse button to add
}

menu @Edit_list {
  &Add Item:menu.additem
  &Edit Item:menu.edititem $sline(%menu.windowname,1).ln
  &Delete Item:menu.delitem $sline(%menu.windowname,1).ln
}

; --[ New dialog functions ]-----------------------------------

; Turn on consecutive checkboxes in dialog $1, starting at id 2, determined by
; $3-.  Entries must be separated by a single "." parameter
alias turnon {
  set %count $2
  set %mark 1
  :loop
  set %item $gettok($3-,%mark,32)
  if (%item == $null) {
    unset %count %mark %item
    return
  }
  if (%item != .) {
    if (%item) did -c $1 %count
    inc %mark
  }
  inc %mark
  inc %count
  goto loop
}

alias dumpin {
  set %count $2
  set %mark 1
  :loop
  set %item $gettok($3-,%mark,32)
  if (%item == $null) {
    unset %count %mark %item
    return
  }
  if (%item != .) {
    did -o $1 %count 1 %item
    inc %mark
  }
  inc %mark
  inc %count
  goto loop
}

alias splatinto {
  set %splat.dialog $1
  set %splat.id $2
}

alias splat {
  did -o %splat.dialog %splat.id 1 $1-
  inc %splat.id

}

alias getstate {
  if ($2 != $null) {
    set %getstate.dialog $1
    set %getstate.count $2
  }
  set %getstate.result $did(%getstate.dialog,%getstate.count).state
  inc %getstate.count
  return %getstate.result
}

alias getdata {
  if ($2 != $null) {
    set %getstate.dialog $1
    set %getstate.count $2
  }
  set %getstate.result $did(%getstate.dialog,%getstate.count,1)
  inc %getstate.count
  return %getstate.result
}

alias loadlist {
  set %count 1
  :loop
  set %item $gettok($4-,%count,$3)
  if (%item != $null) {
    did -a $1 $2 %item
    inc %count
    goto loop
  }
}

alias getlist {
  unset %foo
  set %count 1
  :loop
  set %item $did($1,$2,%count)
  if (%item != $null) {
    set %foo $addtok(%foo,%item,$3)
    inc %count
    goto loop
  }
  return %foo
}

; Add the contents of editbox in dialog $1 at id $3 to the list at id $2, and
; highlight the item
alias handleadd {
  ; If $2 == $3, assume we're dealing with a combobox
  if ($2 == $3) {
    did -ac $1 $2 $did($1,$3,0)
  }
  else {
    did -ac $1 $2 $did($1,$3,1)
  }
}

; Replace the contents of the selected item in list in dialog $1 at id $2 with the
; contents of the editbox at id $3.
alias handleupd {
  did -oc $1 $2 $did($1,$2).sel $did($1,$3,1)
}

; Delete the selected item from the list in dialog $1 at id $2, select the next item,
; place it in editbox at if $3, and enable/disable the controls at ids $4- as appropriate
alias handledel {
  ;  var %line = 1
  ;  if ($2 == $3) set %line 0
  set %foo $did($1,$2).sel
  did -d $1 $2 %foo
  if ($did($1,$2).lines != 0) {
    did -c $1 $2 %foo
    handleselect $1 $3 $2
  }
  else {
    did -r $1 $3
    set %count 1
    :loop
    set %item $gettok($4-,%count,32)
    if (%item != $null) {
      did -b $1 %item
      inc %count
      goto loop
    }
  }
}

; If editbox in dialog $1 at id $2 is empty, disable the controls at ids $3-, else
; enable them
alias handleedit {
  var %line = 1

  if (0* iswm $2) set %line 0
  if ($did($1,$2,%line) != $null) {
    set %opt -e
  }
  else {
    set %opt -b
  }
  set %count 1
  :loop
  set %item $gettok($3-,%count,32)
  if (%item != $null) {
    did %opt $1 %item
    inc %count
    goto loop
  }
  if (%line != 0) did -f $1 $2
}

; Overwrite the contents of edit box in dialog $1 at id $2 with the selected item
; from the list at id $3.  Enable the controls at id $4-
alias handleselect {
  if ($2 != $3) {
    did -o $1 $2 1 $did($1,$3,$did($1,$3).sel)
  }
  set %count 1
  :loop
  set %item $gettok($4-,%count,32)
  if (%item != $null) {
    did -e $1 %item
    inc %count
    goto loop
  }
  did -f $1 $3
}

; Open a dialog, closing the old one if it's open
alias redialog {
  if ($dialog($2)) dialog -x $2
  dialog $1-
}
