; K9 Mk. II: A protection and convienience script for mIRC
; Copyright (C) 1999  Nathan Roberts
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;
; To contact the author, send EMail to nathanr@crl.com, or see the web
; page at http://www.crl.com/~nathanr/k9.html

; Main K9 Module
; **************
; This module contains the menus and startup routines, and some other
; fundamental stuff

; --------------------
; -- Module manager --
; --------------------

alias module {
  if ($script($1) != $null) return
  set %k9.foo $scriptdir $+ $1
  if ($exists(%k9.foo)) {
    load -rs %k9.foo
  }
  else {
    echo $colour(notice) -s *** Error: K9 needs the file $1
    echo $colour(notice) -s *** Make sure that this file is located in the same directory as K9.MRC
    unset %k9.foo
    halt
  }
  unset %k9.foo
}

; --------------------------------
; -- Window retriever subsystem --
; --------------------------------

on 1:close:@:{
  if ($left($target,4) == @K-9) || ($findtok(@Nick_Info/@Channel_Info/@Away/@Pager/@Messages,$target,47) != $null) {
    set %k9. $+ $target $window($target).x $window($target).y $window($target).w $window($target).h
  }
}

alias kwin {
  if ($5 == $null) {
    return $1-4
  }
  else {
    return $5-
  }
}

; -------------------------------
; -- K-9 Setup routine remains --
; -------------------------------


alias k9 {
  k9setd
}

alias k9.guard.toggle {
  if $guardon {
    .disable #k9.guard
  }
  else {
    .enable #k9.guard
  }
  if ($1 == v) {
    echo $colour(info) -a *** Channel guarding $endis($guardon)
  }
  updatestatwindow
}

alias k9.guard.nethack {
  set %k9.nethack $lnot(%k9.nethack)
  if ($1 == v) {
    echo $colour(info) -a *** Nethack protection $endis(%k9.nethack)
  }
}

alias k9.flood.toggle {
  set %k9.noflood $lnot(%k9.noflood)
  if ($1 == v) {
    echo $colour(info) -a *** Flood protection $endis(%k9.noflood)
  }
  updatestatwindow
}

alias k9.away.togaway {
  toggleaway -q
}    

alias k9.away.togreturn {
  togglereturn -q
}    

alias k9.quit.togquit {
  togglequit -q
}    

alias k9.autokick.toggle {
  set %k9.autobooton $lnot(%k9.autobooton)
  updatestatwindow
  if ($1 == v) {
    echo $colour(info) -a *** Autokick $endis(%k9.autobooton)
  }
}

alias k9.pervert.toggle {
  set %k9.pervcheck $lnot(%k9.pervcheck)
  if ($1 == v) {
    echo $colour(info) -a *** Pervert checker $endis(%k9.pervcheck)
  }
  updatestatwindow
}

alias k9.badword.toggle {
  set %k9.badwordcheck $lnot(%k9.badwordcheck)
  if ($1 == v) {
    echo $colour(info) -a *** Bad word checker $endis(%k9.badwordcheck)
  }
  updatestatwindow
}

alias ogroup {
  if ($group($1) == on) return 1
}

alias k9.pingresponse.toggle {
  if $pingon {
    .disable #k9.ping
  }
  else {
    .enable #k9.ping
  }
  if ($1 == v) {
    echo $colour(info) -a *** Ping responses $endis($pingon)
  }
  updatestatwindow
}

#k9.ping on

alias pingon {
  return $true
}

ctcp 1:PING:/notice $nick $read %k9.pingresponse.file

#k9.ping end

; -------------------
; -- Status window --
; -------------------

alias color {
  if ($1) {
    return 3
  }
  else {
    return 5
  }
}  

alias menuitem {
  rline $1 %k9.foo $2-
  set %k9.foo %k9.foo + 1
}

alias statwindow {
  if ($window(@K-9_Status).state == $null) {
    window -l @K-9_Status $kwin(20,30,200,190,%k9.@K-9_Status)
  }
  unset %k9.bar
  set %k9.foo 1
  menuitem @K-9_Status Channel guarding .. $color($guardon) $+ $onoff($guardon)
  menuitem @K-9_Status AutoKick .......... $color(%k9.autobooton) $+ $onoff(%k9.autobooton)
  menuitem @K-9_Status Pervert checker ... $color(%k9.pervcheck) $+ $onoff(%k9.pervcheck)
  menuitem @K-9_Status Bad word checker .. $color(%k9.badwordcheck) $+ $onoff(%k9.badwordcheck)
  menuitem @K-9_Status Flood protection .. $color(%k9.noflood) $+ $onoff(%k9.noflood)
  menuitem @K-9_Status Auto-away ......... $color(%k9.awayon) $+ $onoff(%k9.awayon)
  menuitem @K-9_Status Auto-return ....... $color(%k9.awayreturn) $+ $onoff(%k9.awayreturn)
  menuitem @K-9_Status Auto-quit ......... $color(%k9.quiton) $+ $onoff(%k9.quiton)
  menuitem @K-9_Status Log messages ...... $color(%k9.awaylog) $+ $onoff(%k9.awaylog)
  menuitem @K-9_Status Pager ............. $color(%k9.pager) $+ $onoff(%k9.pager)
  menuitem @K-9_Status Ping Responses..... $color($pingon) $+ $onoff($pingon)
  menuitem @K-9_Status Away .............. $color($lnot($away)) $+ $yesno($away)
  unset %k9.foo
}

; -- Update K9 status window, only if it's open --
alias updatestatwindow {
  if ($window(@K-9_Status).state != $null) statwindow
}

; -- Audio feedback alias --
alias master {
  if (%k9.audio == Master) splay $scriptdir $+ k9master.wav
  if (%k9.audio == Mistress) splay $scriptdir $+ k9mstrs.wav
}

; -------------------
; -- CTCP Response --
; -------------------

ctcp 1:version:{
  .ctcpreply $nick SCRIPT $K9version
}

; -------------------
; -- Function Keys --
; -------------------

; -- Shift-F3: K9 Setup --
alias sf3 {
  k9
}

; -- Ctrl-F3: Status window --
alias cf3 {
  statwindow
}

; -- F3: K9 Help --
alias f3 {
  k9helpcon
}

; ---------------------------
; -- Add status menu items --
; ---------------------------

alias k9versionno {
  return Beta000324
}

alias k9versiontag {
  if (%k9.versiontag) return , %k9.versiontag
}

alias k9version {
  return K-9 Mk. II $k9versionno $+ $k9versiontag - 2000, Nathan Roberts & Richard Poser - http://www.crl.com/~nathanr/k9.html
}

alias ifchan {
  if (# != $null) return $1-
}

alias ifdalnet {
  if ($dalnet) && ($1 != $null) return $1-
}

alias showscript {
  if (# != $null) {
    me is running: $k9version
  }
  else {
    echo $colour(info) -s *** $k9version
  }
}

alias k9splash {
  k9about
  if ($1 == $null) {
    .timer 1 5 if ($dialog(k9about)) dialog -x k9about
  }
  else if ($1 != 0) {
    .timer 1 $1 if ($dialog(k9about)) dialog -x k9about
  }
  ; gplnotice
}

menu @K9 {
  sclick:window -c @k9
}

; ----------------
; -- Initialize --
; ----------------

on 1:load:{
  if (%k9.maxdeop == $null) set %k9.maxdeop 3
  if (%k9.maxkick == $null) set %k9.maxkick 3
  if (%k9.guardtime == $null) set %k9.guardtime 10
  if (%k9.cfloodlines == $null) set %k9.cfloodlines 5
  if (%k9.cfloodtime == $null) set %k9.cfloodtime 10
  if (%k9.noflood == $null) set %k9.noflood $true
  if (%k9.floodthresh == $null) set %k9.floodthresh 4
  if (%k9.floodchktime == $null) set %k9.floodchktime 5
  if (%k9.floodignore == $null) set %k9.floodignore 30
  if (%k9.returnmsg == $null) set %k9.returnmsg is back.
  if (%k9.autoawaymsg == $null) set %k9.autoawaymsg Auto-away
  if (%k9.awaytimeout == $null) set %k9.awaytimeout 300
  if (%k9.awayon == $null) set %k9.awayon $true
  if (%k9.awayreturn == $null) set %k9.awayreturn $true
  if (%k9.awaylog == $null) set %k9.awaylog $true
  if (%k9.autoquitmsg == $null) set %k9.autoquitmsg Auto-quit
  if (%k9.quittimeout == $null) set %k9.quittimeout 3600
  if (%k9.quiton == $null) set %k9.quiton $false
  if (%k9.audio == $null) set %k9.audio Master
  if (%k9.audio == $true) set %k9.audio Master
  if (%k9.audio == $false) set %k9.audio Off
  if (%k9.pager == $null) set %k9.pager $true
  if (%k9.pager.wav == $null) set %k9.pager.wav $scriptdir $+ siren.wav
  if (%k9.pager.time == $null) set %k9.pager.time 30
  if (%k9.pager.interval == $null) set %k9.pager.interval 1
  if (%k9.pervwords == $null) set %k9.pervwords sex,porn,warez
  if (%k9.pervwav == $null) set %k9.pervwav $scriptdir $+ warning.wav
  if (%k9.badwords == $null) set %k9.badwords fuck
  if (%k9.badwwav == $null) set %k9.badwwav $scriptdir $+ warning.wav
  if (%k9.splash == $null) set %k9.splash $true
  if (%k9.tbar == $null) set %k9.tbar $true
  if (%k9.noslash == $null) set %k9.noslash $true
  if (%k9.colinactions == $null) set %k9.colinactions $true
  if (%k9.sound.connect == $null) setwav connect
  if (%k9.sound.join == $null) setwav join
  if (%k9.sound.part == $null) setwav part
  if (%k9.sound.action == $null) setwav action
  if (%k9.sound.nickchange == $null) setwav nickchange nick
  if (%k9.sound.topicchange == $null) setwav topicchange topic
  if (%k9.sound.notify == $null) setwav notify
  if (%k9.sound.notifyoff == $null) setwav notifyoff unotify
  if (%k9.sound.op == $null) setwav op
  if (%k9.sound.opme == $null) setwav opme
  if (%k9.sound.deop == $null) setwav deop
  if (%k9.sound.deopme == $null) setwav deopme
  if (%k9.sound.kick == $null) setwav kick
  if (%k9.sound.kickme == $null) setwav kickme
  if (%k9.sound.invite == $null) setwav invite
  if (%k9.sound.message == $null) setwav message
  if (%k9.sound.notice == $null) setwav notice
  if (%k9.sound.ping == $null) setwav ping
  if (%k9.sound.quit == $null) setwav quit
  if (%k9.pingresponse.file == $null) setping
  module k9b.mrc
  module k9c.mrc
  module k9d.mrc
  module k9e.mrc
  module k9f.mrc
  module k9h.mrc
  module k9s.mrc
  module menus.mrc
  k9
  .ial on
  .ctcps on
  .events on
  .raw on
  k9splash
}

alias setping {
  set %k9.pingset $scriptdir $+ ping.txt
  if ($exists(%k9.pingset)) {
    set %k9.pingresponse.file %k9.pingset
    .enable #k9.ping
  }
  else {
    .disable #k9.ping
  }
  unset %k9.pingset
}

alias setwav {
  if ($2 == $null) {
    set %k9.wavset $1
  }
  else {
    set %k9.wavset $2
  }
  set %k9.wavset $scriptdir $+ %k9.wavset $+ .wav
  if ($exists(%k9.wavset)) set %k9.sound. $+ $1 %k9.wavset
  unset %k9.wavset
}

alias sf1 {
  if ($server == $null) {
    profiles
  }
  else if (%profile.loggedin) {
    chanlist
  }
}

alias gplnotice {
  linesep -s
  echo -s K9 Mk. II $k9versionno $+ , Copyright (C) 1999 Nathan Roberts
  echo -s K9 Mk. II comes with ABSOLUTELY NO WARRANTY.  This is free software, and you are welcome to redistribute it under certain conditions.  See the file COPYING for details.
  linesep -s
}

on 1:start:{
  unset %k9.dop %k9.ghost %k9.foo %k9.bar %k9.awaynick %k9.floodcount %k9.awaytimer %k9.quittimer %k9.pager.timer
  if (%k9.statstart) statwindow
  if ($script(k9s.mrc) != $null) k9sstart
  echo $colour(info) -s *** K-9 loaded - Press F3 for help
  gplnotice
  if (%k9.splash) k9splash 3
  if (*_Away iswm $me) && (%k9.awayadd) nick $left($me,-5)
  unset %k9.quitwarning
}

on 1:connect:{
  unset %k9.pervnick %k9.pervchan %k9.pervfname %k9.pervfchan %k9.pervfound %k9.lastinvite
  if (*_Away iswm $me) && (%k9.awayadd) nick $left($me,-5)
}
