; K9 Mk. II: A protection and convienience script for mIRC
; Copyright (C) 1999  Nathan Roberts
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;
; To contact the author, send EMail to nathanr@crl.com, or see the web
; page at http://www.crl.com/~nathanr/k9.html

; --[ Channel guarding dialog ]----------------

dialog k9guard {
  title "Channel Guarding"
  size   -1 -1 310 390

  button "Ok", 1, 260 370 050 020, ok, default
  button "&Help", 100, 210 370 050 020

  box "Channe&ls:", 2, 000 000 100 155
  list 3, 005 015 090 145, sort

  box "Cha&nnel:", 8, 105 000 200 070
  edit "", 9, 110 015 190 020

  button  "&Add", 10, 110 040 050 020, disabled
  button  "&Remove", 11, 180 040 050 020, disabled
  button  "&Update", 12, 250 040 050 020, disabled

  box "Options", 13, 105 075 200 080
  check "Channel guarding &Enabled", 4, 110 090 190 015
  check "&Cycle channel to regain ops", 5, 110 105 190 015
  check "Deop server &ops", 6, 110 120 190 015
  check "Enable &panic button", 7, 110 135 190 015

  box "&Auto-Deop", 14, 0, 160, 310, 120
  check "Automatically deop someone after...", 20, 5, 175, 300, 20
  edit "", 31, 5, 195, 35, 20
  text " deops, or", 16, 40, 195, 260, 20
  edit "", 32, 5, 215, 35, 20
  text " kicks in", 17, 40, 215, 260, 20
  edit "", 33, 5, 235, 35, 20
  text " seconds", 18, 40, 235, 260, 20
  check "Only if they kick an op", 21, 5, 255, 300, 20

  box "Flood", 40, 0, 285, 310, 80
  check "Target for flooding after...", 22, 5, 300, 300, 20
  edit "", 34, 5, 320, 35, 20
  text " lines in", 41, 40, 320, 260, 20
  edit "", 35, 5, 340, 35, 20
  text " seconds", 42, 40, 340, 260, 20
}

on 1:dialog:k9guard:init:0:{
  loadlist k9guard 3 44 %k9.chans
  turnon k9guard 4 $guardon . %k9.regain . %k9.nethack . %k9.panic
  turnon k9guard 20 %k9.deopcheck . %k9.onlyopkick . %k9.targetflood
  dumpin k9guard 31 %k9.maxdeop . %k9.maxkick . %k9.guardtime . %k9.cfloodlines . %k9.cfloodtime
}

on 1:dialog:k9guard:sclick:3:handleselect k9guard 9 3 10 11 12
on 1:dialog:k9guard:edit:9:{
  handleedit k9guard 9 10 12
  if ($did(k9guard,3).sel == $null) did -b k9guard 12
  did -f k9guard 9
}
on 1:dialog:k9guard:sclick:10:handleadd k9guard 3 9
on 1:dialog:k9guard:sclick:11:handledel k9guard 3 9 10 11 12
on 1:dialog:k9guard:sclick:12:handleupd k9guard 3 9

on 1:dialog:k9guard:sclick:100:k9helpd Channel-guarding Channel Guarding

on 1:dialog:k9guard:sclick:1:{
  if ($did(k9guard,4).state) {
    .enable #k9.guard
  }
  else {
    .disable #k9.guard
  }
  set %k9.regain $getstate(k9guard,5)
  set %k9.nethack $getstate
  set %k9.panic $getstate
  set %k9.chans $getlist(k9guard,3,44)
  set %k9.deopcheck $getstate(k9guard,20)
  set %k9.onlyopkick $getstate
  set %k9.targetflood $getstate
  set %k9.maxdeop $getdata(k9guard,31)
  set %k9.maxkick $getdata
  set %k9.guardtime $getdata
  set %k9.cfloodlines $getdata
  set %k9.cfloodtime $getdata
  updatestatwindow
  dialog -v k9settings
}

alias k9guardd {
  redialog -m k9guard k9guard
}

; --[ Flood protection ]----------------

dialog k9flood {
  title "Flood Protection"
  size   -1 -1 190 130

  check   "&Enable flood protection", 2, 000 010 155 015
  text    "Flood &threshold:", 3, 000 043 100 015
  edit    "", 10, 100 040 040 020
  text    "Flood &check time:", 4, 000 063 100 015
  edit    "", 11, 100 060 040 020
  text    " seconds", 20, 140 063 050 015
  text    "Flood &ignore time:", 5, 000 083 100 015
  edit    "", 12, 100 080 040 020
  text    " seconds", 21, 140 083 050 015

  button  "Ok", 1, 140 110 050 020, ok, default
  button  "&Help", 100, 090 110 050 020
}

on 1:dialog:k9flood:init:0:{
  turnon k9flood 2 %k9.noflood
  dumpin k9flood 10 %k9.floodthresh . %k9.floodchktime . %k9.floodignore
}

on 1:dialog:k9flood:sclick:100:k9helpd Flood-protection Flood Protection

on 1:dialog:k9flood:sclick:1:{
  set %k9.floodthresh $getdata(k9flood,10)
  set %k9.floodchktime $getdata
  set %k9.floodignore $getdata
  set %k9.noflood $getstate(k9flood,2)
  updatestatwindow
  dialog -v k9settings
}

alias k9floodd {
  redialog -m k9flood k9flood
}

; --[ Nick management ]----------------

dialog k9nick {
  title "Nick Management"
  size   -1 -1 210 155

  check   "Auto-&Identify", 2, 010 010 155 015
  check   "Identify on &connect", 3, 010 025 155 015
  check   "Identify on Nick Change", 8, 010 040 170 015
  check   "Auto-&Ghost", 4, 010 055 155 015
  check   "Auto-&Recover", 5, 010 070 155 015
  text    "Primary &Nick:", 6, 010 093 100 015
  edit    "", 10, 110 090 100 020
  text    "Nickserv &Password:", 7, 010 113 100 015
  edit    "", 11, 110 110 100 020

  button  "Ok", 1, 160 135 050 020, ok, default
  button  "&Help", 100, 110 135 050 020
}

on 1:dialog:k9nick:init:0:{
  turnon k9nick 2 %k9.autoid . %k9.idconnect . %k9.autoghost . %k9.autorecover
  turnon k9nick 8 %k9.autoidnick
  dumpin k9nick 10 %k9.nick . %k9.nickpass
}

on 1:dialog:k9nick:sclick:100:k9helpd Nick-management Nickname management

on 1:dialog:k9nick:sclick:1:{
  set %k9.autoid $getstate(k9nick,2)
  set %k9.idconnect $getstate
  set %k9.autoghost $getstate
  set %k9.autorecover $getstate
  set %k9.nick $getdata(k9nick,10)
  set %k9.nickpass $getdata
  set %k9.autoidnick $getstate(k9nick,8)
  updatestatwindow
  dialog -v k9settings
}

alias k9nickd {
  redialog -m k9nick k9nick
}

; --[ Away system ]----------------

dialog k9away {
  title "Away System"
  size   -1 -1 500 300

  check   "Auto-A&way", 2, 010 010 155 015
  check   "Auto-&Return", 3, 010 025 155 015
  check   "&Log messages when away", 4, 010 040 155 015

  text    "Return &message:", 5, 010 068 100 015
  edit    "", 10, 110 065 390 020
  text    "Auto-Away me&ssage:", 6, 010 088 100 015
  edit    "", 11, 110 085 390 020
  text    "Auto-Away &timeout:", 7, 010 108 100 015
  edit    "", 12, 110 105 050 020
  text    " minutes", 20, 160 108 100 015

  check   "Add _away to &nick", 8, 010 128 155 015

  text    "Messa&ge:", 30, 010 155 050 015
  edit    "", 31, 010 170 490 020
  list    32, 010 190 490 90

  button  "&Add", 40, 350 150 050 020, disabled
  button  "&Delete", 41, 400 150 050 020, disabled
  button  "&Update", 42, 450 150 050 020, disabled

  button  "&Help", 100, 400 280 050 020
  button  "Ok", 1, 450 280 050 020, ok, default
}

on 1:dialog:k9away:init:0:{
  turnon k9away 2 %k9.awayon . %k9.awayreturn . %k9.awaylog
  did -o k9away 10 1 %k9.returnmsg
  did -o k9away 11 1 %k9.autoawaymsg
  did -o k9away 12 1 $calc(%k9.awaytimeout / 60)
  turnon k9away 8 %k9.awayadd
  loadlist k9away 32 126 %k9.awaymsg
}

on 1:dialog:k9away:sclick:32:handleselect k9away 31 32 40 41 42
on 1:dialog:k9away:edit:31:{
  handleedit k9away 31 40 42
  if ($did(k9away,32).sel == $null) did -b k9away 42
  did -f k9away 31
}
on 1:dialog:k9away:sclick:40:handleadd k9away 32 31
on 1:dialog:k9away:sclick:41:handledel k9away 32 31 40 41 42
on 1:dialog:k9away:sclick:42:handleupd k9away 32 31

on 1:dialog:k9away:sclick:100:k9helpd Away-system Away System

on 1:dialog:k9away:sclick:1:{
  set %k9.awayon $getstate(k9away,2)
  set %k9.awayreturn $getstate
  set %k9.awaylog $getstate
  set %k9.awayadd $getstate(k9away,8)
  set %k9.returnmsg $getdata(k9away,10)
  set %k9.autoawaymsg $getdata
  set %k9.awaytimeout $calc($getdata * 60)
  set %k9.awaymsg $getlist(k9away,32,126)
  if ( %k9.awayon ) {
    checkaway
  }
  else {
    .timerk9away off
  }
  updatestatwindow
  dialog -v k9settings
}

alias k9awayd {
  redialog -m k9away k9away
}

; --[ Quit system ]----------------

dialog k9quit {
  title "Quit System"
  size   -1 -1 500 220

  check   "Auto-&Quit", 2, 010 010 155 015
  text    "Auto-Quit me&ssage:", 6, 010 028 100 015
  edit    "", 10, 110 025 390 020
  text    "Auto-Quit &timeout:", 7, 010 048 100 015
  edit    "", 11, 110 045 050 020
  text    " minutes", 20, 160 048 100 015

  text    "Messa&ge:", 30, 010 075 050 015
  edit    "", 31, 010 090 490 020
  list    32, 010 110 490 90

  button  "&Add", 40, 350 070 050 020, disabled
  button  "&Delete", 41, 400 070 050 020, disabled
  button  "&Update", 42, 450 070 050 020, disabled

  button  "&Help", 100, 400 200 050 020
  button  "Ok", 1, 450 200 050 020, ok, default
}

on 1:dialog:k9quit:init:0:{
  turnon k9quit 2 %k9.quiton
  did -o k9quit 10 1 %k9.autoquitmsg
  did -o k9quit 11 1 $calc(%k9.quittimeout / 60)
  loadlist k9quit 32 126 %k9.quitmsg
}

on 1:dialog:k9quit:sclick:32:handleselect k9quit 31 32 40 41 42
on 1:dialog:k9quit:edit:31:{
  handleedit k9quit 31 40 42
  if ($did(k9quit,32).sel == $null) did -b k9quit 42
  did -f k9quit 31
}
on 1:dialog:k9quit:sclick:40:handleadd k9quit 32 31
on 1:dialog:k9quit:sclick:41:handledel k9quit 32 31 40 41 42
on 1:dialog:k9quit:sclick:42:handleupd k9quit 32 31

on 1:dialog:k9quit:sclick:100:k9helpd Quit-System Quit System

on 1:dialog:k9quit:sclick:1:{
  set %k9.quiton $getstate(k9quit,2)
  set %k9.autoquitmsg $getdata(k9quit,10)
  set %k9.quittimeout $calc($getdata * 60)
  set %k9.quitmsg $getlist(k9quit,32,126)
  if (%k9.quiton) {
    checkquit
  }
  else {
    .timerk9quit off
  }
  updatestatwindow
  dialog -v k9settings
}

alias k9quitd {
  redialog -m k9quit k9quit
}

; --[ Autokick system ]----------------

dialog k9akick {
  title "Autokick System"
  size   -1 -1 500 180

  check   "Autokick &enabled", 2, 010 010 155 015

  text    "Add&ress:", 30, 010 035 050 015
  edit    "", 31, 010 050 490 020
  list    32, 010 070 490 090

  button  "&Add", 40, 350 030 050 020, disabled
  button  "&Delete", 41, 400 030 050 020, disabled
  button  "&Update", 42, 450 030 050 020, disabled

  button  "&Help", 100, 400 160 050 020
  button  "Ok", 1, 450 160 050 020, ok, default
}

on 1:dialog:k9akick:init:0:{
  turnon k9akick 2 %k9.autobooton
  loadlist k9akick 32 44 %k9.autoboot
}

on 1:dialog:k9akick:sclick:32:handleselect k9akick 31 32 40 41 42
on 1:dialog:k9akick:edit:31:{
  handleedit k9akick 31 40 42
  if ($did(k9akick,32).sel == $null) did -b k9akick 42
  did -f k9akick 31
}
on 1:dialog:k9akick:sclick:40:handleadd k9akick 32 31
on 1:dialog:k9akick:sclick:41:handledel k9akick 32 31 40 41 42
on 1:dialog:k9akick:sclick:42:handleupd k9akick 32 31

on 1:dialog:k9akick:sclick:100:k9helpd Autokick AutoKick System

on 1:dialog:k9akick:sclick:1:{
  set %k9.autobooton $getstate(k9akick,2)
  set %k9.autoboot $getlist(k9akick,32,44)
  updatestatwindow
  if ($dialog(k9settings)) dialog -v k9settings
}

alias k9akickd {
  redialog -m k9akick k9akick
}

; --[ Pervert checker ]----------------

dialog k9perv {
  title "Pervert checker"
  size   -1 -1 500 200

  check   "Pervert checker &enabled", 2, 010 010 155 015

  text    "Alert sound:", 3, 300 010 100 015
  edit    "", 4, 300 025 200 020
  button  "Select...", 5, 450 005 050 020
  button  "Test", 6, 400 005 050 020

  text    "Word:", 30, 010 060 050 015
  edit    "", 31, 010 075 490 020
  list    32, 010 095 490 090

  button  "&Add", 40, 350 055 050 020, disabled
  button  "&Delete", 41, 400 055 050 020, disabled
  button  "&Update", 42, 450 055 050 020, disabled

  button  "&Help", 100, 400 180 050 020
  button  "Ok", 1, 450 180 050 020, ok, default
}

on 1:dialog:k9perv:init:0:{
  turnon k9perv 2 %k9.pervcheck
  dumpin k9perv 4 %k9.pervwav
  loadlist k9perv 32 44 %k9.pervwords
}

on 1:dialog:k9perv:sclick:32:handleselect k9perv 31 32 40 41 42
on 1:dialog:k9perv:edit:31:{
  handleedit k9perv 31 40 42
  if ($did(k9perv,32).sel == $null) did -b k9perv 42
  did -f k9perv 31
}
on 1:dialog:k9perv:sclick:40:handleadd k9perv 32 31
on 1:dialog:k9perv:sclick:41:handledel k9perv 32 31 40 41 42
on 1:dialog:k9perv:sclick:42:handleupd k9perv 32 31

on 1:dialog:k9perv:sclick:5:{
  spt getpwav
}

on 1:dialog:k9perv:sclick:6:{
  splay $did(k9perv,4,1)
}

alias getpwav {
  set %k9.foo $scriptdir $+ *.wav
  set %k9.foo $dir="Select .WAV file for pervert alert" %k9.foo
  if (%k9.foo != $null) {
    did -o k9perv 4 1 %k9.foo
    unset %k9.foo
  }
}

on 1:dialog:k9perv:sclick:100:k9helpd Pervert-checker Pervert Checker

on 1:dialog:k9perv:sclick:1:{
  set %k9.pervcheck $getstate(k9perv,2)
  set %k9.pervwav $getdata(k9perv,4)
  set %k9.pervwords $getlist(k9perv,32,44)
  updatestatwindow
  dialog -v k9settings
}

alias k9pervd {
  redialog -m k9perv k9perv
}

; --[ Bad Word checker ]----------------

dialog k9badword {
  title "Bad Word checker"
  size   -1 -1 500 200

  check   "Bad Word Checker &enabled", 2, 010 010 155 015

  text    "Alert sound:", 3, 300 010 100 015
  edit    "", 4, 300 025 200 020
  button  "Select...", 5, 450 005 050 020
  button  "Test", 6, 400 005 050 020

  text    "Word:", 30, 010 060 050 015
  edit    "", 31, 010 075 490 020
  list    32, 010 095 490 090

  button  "&Add", 40, 350 055 050 020, disabled
  button  "&Delete", 41, 400 055 050 020, disabled
  button  "&Update", 42, 450 055 050 020, disabled

  button  "&Help", 100, 400 180 050 020
  button  "Ok", 1, 450 180 050 020, ok, default
}

on 1:dialog:k9badword:init:0:{
  turnon k9badword 2 %k9.badwordcheck
  dumpin k9badword 4 %k9.badwwav
  loadlist k9badword 32 44 %k9.badwords
}

on 1:dialog:k9badword:sclick:32:handleselect k9badword 31 32 40 41 42
on 1:dialog:k9badword:edit:31:{
  handleedit k9badword 31 40 42
  if ($did(k9badword,32).sel == $null) did -b k9badword 42
  did -f k9badword 31
}
on 1:dialog:k9badword:sclick:40:handleadd k9badword 32 31
on 1:dialog:k9badword:sclick:41:handledel k9badword 32 31 40 41 42
on 1:dialog:k9badword:sclick:42:handleupd k9badword 32 31

on 1:dialog:k9badword:sclick:5:{
  spt getbwav
}

on 1:dialog:k9badword:sclick:6:{
  splay $did(k9badword,4,1)
}

alias getbwav {
  set %k9.foo $scriptdir $+ *.wav
  set %k9.foo $dir="Select .WAV file for bad word alert" %k9.foo
  if (%k9.foo != $null) {
    did -o k9badword 4 1 %k9.foo
    unset %k9.foo
  }
}

on 1:dialog:k9badword:sclick:100:k9helpd badword-checker Bad Word Checker

on 1:dialog:k9badword:sclick:1:{
  set %k9.badwordcheck $getstate(k9badword,2)
  set %k9.badwwav $getdata(k9badword,4)
  set %k9.badwords $getlist(k9badword,32,44)
  updatestatwindow
  dialog -v k9settings
}

alias k9badwordd {
  redialog -m k9badword k9badword
}

; --[ IRC Pager ]--------------------

dialog k9pager {
  title "IRC Pager"
  size   -1 -1 220 160

  check   "IRC Pager &enabled", 2, 010 010 155 015

  text    "Page &time:", 7, 010 035 070 015
  edit    "", 8, 080 030 055 020

  text    "Page &interval:", 9, 010 055 070 015
  edit    "", 10, 080 050 055 020

  text    "Alert sound:", 3, 010 090 100 015
  edit    "", 4, 010 105 200 020
  button  "Select...", 5, 160 085 050 020
  button  "Test", 6, 110 085 050 020

  button  "&Help", 100, 110 135 050 020
  button  "Ok", 1, 160 135 050 020, ok, default
}

on 1:dialog:k9pager:init:0:{
  turnon k9pager 2 %k9.pager
  dumpin k9pager 4 %k9.pager.wav
  dumpin k9pager 8 %k9.pager.time
  dumpin k9pager 10 %k9.pager.interval
}

on 1:dialog:k9pager:sclick:5:{
  spt getpgwav
}

on 1:dialog:k9pager:sclick:6:{
  splay $did(k9pager,4,1)
}

alias getpgwav {
  set %k9.foo $scriptdir $+ *.wav
  set %k9.foo $dir="Select .WAV file for pager" %k9.foo
  if (%k9.foo != $null) {
    did -o k9pager 4 1 %k9.foo
    unset %k9.foo
  }
}

on 1:dialog:k9pager:sclick:100:k9helpd pager IRC Pager

on 1:dialog:k9pager:sclick:1:{
  set %k9.pager $getstate(k9pager,2)
  set %k9.pager.wav $getdata(k9pager,4)
  set %k9.pager.time $getdata(k9pager,8)
  set %k9.pager.interval $getdata(k9pager,10)
  updatestatwindow
  dialog -v k9settings
}

alias k9pagerd {
  redialog -m k9pager k9pager
}

; --[ Sound Harvester ]--------------------

dialog k9sound {
  title "Sound Harvester"
  size   -1 -1 220 100

  check   "Automatically &grab WAVs", 2, 010 010 200 015
  check   "Automatically &play grabed WAVs", 3, 010 025 200 015
  check   "Automatically &accept WAV DCCs", 4, 010 040 200 015
  check   "&Show sound names", 5, 010 055 200 015

  button  "&Help", 100, 120 080 050 020
  button  "Ok", 1, 170 080 050 020, ok, default
}

on 1:dialog:k9sound:init:0:{
  turnon k9sound 2 %k9.autograb . %k9.playlastgrab . %k9.autoaccept . %k9.showsound
}

on 1:dialog:k9sound:sclick:100:k9helpd sound-harvester Sound Harvester

on 1:dialog:k9sound:sclick:1:{
  set %k9.autograb $getstate(k9sound,2)
  set %k9.playlastgrab $getstate(k9sound,3)
  set %k9.autoaccept $getstate(k9sound,4)
  set %k9.showsound $getstate(k9sound,5)
  updatestatwindow
  dialog -v k9settings
}

alias k9soundd {
  redialog -m k9sound k9sound
}

; --[ IRC Pager ]--------------------

dialog k9eventsound {
  title "Event sounds"
  size   -1 -1 415 430

  check   "Event sounds &enabled", 2, 010 010 155 015

  text    "Connect:", 10, 010 035 070 015
  edit    "", 100, 085 030 170 020
  button  "Select...", 200, 255 030 050 020
  button  "Test", 300, 305 030 050 020
  button  "None", 400, 355 030 050 020

  text    "Join:", 11, 010 055 070 015
  edit    "", 101, 085 050 170 020
  button  "Select...", 201, 255 050 050 020
  button  "Test", 301, 305 050 050 020
  button  "None", 401, 355 050 050 020

  text    "Part:", 12, 010 075 070 015
  edit    "", 102, 085 070 170 020
  button  "Select...", 202, 255 070 050 020
  button  "Test", 302, 305 070 050 020
  button  "None", 402, 355 070 050 020

  text    "Action:", 13, 010 095 070 015
  edit    "", 103, 085 090 170 020
  button  "Select...", 203, 255 090 050 020
  button  "Test", 303, 305 090 050 020
  button  "None", 403, 355 090 050 020

  text    "Nick change:", 14, 010 115 070 015
  edit    "", 104, 085 110 170 020
  button  "Select...", 204, 255 110 050 020
  button  "Test", 304, 305 110 050 020
  button  "None", 404, 355 110 050 020

  text    "Topic change:", 15, 010 135 070 015
  edit    "", 105, 085 130 170 020
  button  "Select...", 205, 255 130 050 020
  button  "Test", 305, 305 130 050 020
  button  "None", 405, 355 130 050 020

  text    "Notify:", 16, 010 155 070 015
  edit    "", 106, 085 150 170 020
  button  "Select...", 206, 255 150 050 020
  button  "Test", 306, 305 150 050 020
  button  "None", 406, 355 150 050 020

  text    "Notify off:", 17, 010 175 070 015
  edit    "", 107, 085 170 170 020
  button  "Select...", 207, 255 170 050 020
  button  "Test", 307, 305 170 050 020
  button  "None", 407, 355 170 050 020

  text    "Op:", 18, 010 195 070 015
  edit    "", 108, 085 190 170 020
  button  "Select...", 208, 255 190 050 020
  button  "Test", 308, 305 190 050 020
  button  "None", 408, 355 190 050 020

  text    "Op me:", 19, 010 215 070 015
  edit    "", 109, 085 210 170 020
  button  "Select...", 209, 255 210 050 020
  button  "Test", 309, 305 210 050 020
  button  "None", 409, 355 210 050 020

  text    "Deop:", 20, 010 235 070 015
  edit    "", 110, 085 230 170 020
  button  "Select...", 210, 255 230 050 020
  button  "Test", 310, 305 230 050 020
  button  "None", 410, 355 230 050 020

  text    "Deop me:", 21, 010 255 070 015
  edit    "", 111, 085 250 170 020
  button  "Select...", 211, 255 250 050 020
  button  "Test", 311, 305 250 050 020
  button  "None", 411, 355 250 050 020

  text    "Kick:", 22, 010 275 070 015
  edit    "", 112, 085 270 170 020
  button  "Select...", 212, 255 270 050 020
  button  "Test", 312, 305 270 050 020
  button  "None", 412, 355 270 050 020

  text    "Kick me:", 23, 010 295 070 015
  edit    "", 113, 085 290 170 020
  button  "Select...", 213, 255 290 050 020
  button  "Test", 313, 305 290 050 020
  button  "None", 413, 355 290 050 020

  text    "Invite:", 24, 010 315 070 015
  edit    "", 114, 085 310 170 020
  button  "Select...", 214, 255 310 050 020
  button  "Test", 314, 305 310 050 020
  button  "None", 414, 355 310 050 020

  text    "Message:", 25, 010 335 070 015
  edit    "", 115, 085 330 170 020
  button  "Select...", 215, 255 330 050 020
  button  "Test", 315, 305 330 050 020
  button  "None", 415, 355 330 050 020

  text    "Notice:", 26, 010 355 070 015
  edit    "", 116, 085 350 170 020
  button  "Select...", 216, 255 350 050 020
  button  "Test", 316, 305 350 050 020
  button  "None", 416, 355 350 050 020

  text    "Ping:", 27, 010 375 070 015
  edit    "", 117, 085 370 170 020
  button  "Select...", 217, 255 370 050 020
  button  "Test", 317, 305 370 050 020
  button  "None", 417, 355 370 050 020

  text    "Quit:", 28, 010 395 070 015
  edit    "", 118, 085 390 170 020
  button  "Select...", 218, 255 390 050 020
  button  "Test", 318, 305 390 050 020
  button  "None", 418, 355 390 050 020

  button  "&Help", 144, 305 410 050 020
  button  "Ok", 1, 355 410 050 020, ok, default
}

on 1:dialog:k9eventsound:init:0:{
  turnon k9eventsound 2 %k9.eventsounds
  dumpin k9eventsound 100 %k9.sound.connect . %k9.sound.join . %k9.sound.part . %k9.sound.action . %k9.sound.nickchange . %k9.sound.topicchange . %k9.sound.notify . %k9.sound.notifyoff . %k9.sound.op . %k9.sound.opme . %k9.sound.deop . %k9.sound.deopme . %k9.sound.kick . %k9.sound.kickme . %k9.sound.invite . %k9.sound.message . %k9.sound.notice . %k9.sound.ping . %k9.sound.quit
}

on 1:dialog:k9eventsound:sclick:144:k9helpd Event-Sounds Event Sounds

on 1:dialog:k9eventsound:sclick:1:{
  set %k9.eventsounds $getstate(k9eventsound,2)
  set %k9.sound.connect $getdata(k9eventsound,100)
  set %k9.sound.join $getdata
  set %k9.sound.part $getdata
  set %k9.sound.action $getdata
  set %k9.sound.nickchange $getdata
  set %k9.sound.topicchange $getdata
  set %k9.sound.notify $getdata
  set %k9.sound.notifyoff $getdata
  set %k9.sound.op $getdata
  set %k9.sound.opme $getdata
  set %k9.sound.deop $getdata
  set %k9.sound.deopme $getdata
  set %k9.sound.kick $getdata
  set %k9.sound.kickme $getdata
  set %k9.sound.invite $getdata
  set %k9.sound.message $getdata
  set %k9.sound.notice $getdata
  set %k9.sound.ping $getdata
  set %k9.sound.quit $getdata
  updatestatwindow
  dialog -v k9settings
}

on 1:dialog:k9eventsound:sclick:*:{
  if ($did >= 200 && $did <= 299) {
    spt geteswav $calc($did - 100)
  }
  else if ($did >= 300 && $did <= 399) {
    set %k9.foo $did(k9eventsound,$calc($did - 200),1)
    if (%k9.foo) splay %k9.foo
    unset %k9.foo
  }
  else if ($did >= 400 && $did <= 499) {
    did -r k9eventsound $calc($did - 300)
  }
}

alias geteswav {
  set %k9.foo $scriptdir $+ *.wav
  set %k9.foo $dir="Select .WAV file" %k9.foo
  if (%k9.foo != $null) {
    did -o k9eventsound $1 1 %k9.foo
    unset %k9.foo
  }
}

alias k9eventsoundd {
  redialog -m k9eventsound k9eventsound
}

; --[ Ping responses ]--------------------

dialog k9ping {
  title "Ping Responses"
  size   -1 -1 220 100

  check   "Ping responses &enabled", 2, 010 010 155 015

  text    "Response file:", 3, 010 030 100 015
  edit    "", 4, 010 045 200 020
  button  "Select...", 5, 160 025 050 020

  button  "&Help", 100, 110 075 050 020
  button  "Ok", 1, 160 075 050 020, ok, default
}

on 1:dialog:k9ping:init:0:{
  turnon k9ping 2 $pingon
  dumpin k9ping 4 %k9.pingresponse.file
}

on 1:dialog:k9ping:sclick:5:{
  spt getprfile
}

alias getprfile {
  set %k9.foo $scriptdir $+ *.txt
  set %k9.foo $dir="Select ping response file" %k9.foo
  if (%k9.foo != $null) {
    did -o k9ping 4 1 %k9.foo
    unset %k9.foo
  }
}

on 1:dialog:k9ping:sclick:100:k9helpd Ping-responses Ping Responses

on 1:dialog:k9ping:sclick:1:{
  if ($getstate(k9ping,2)) {
    .enable #k9.ping
  }
  else {
    .disable #k9.ping
  }
  set %k9.pingresponse.file $getdata(k9ping,4)
  updatestatwindow
  dialog -v k9settings
}

alias k9pingd {
  redialog -m k9ping k9ping
}

; --[ Options ]--------------------

dialog k9opt {
  title "Options"
  size   -1 -1 220 240

  check   "&Splash screen on startup", 2, 010 010 200 015
  check   "&Put info in title bar", 3, 010 025 200 015
  check   "&Command shortcut", 4, 010 040 200 015
  check   "&Action shortcut", 5, 010 055 200 015
  check   "&Open status window on startup", 6, 010 070 200 015

  box     "Audio feedback", 7, 010 095 200 065

  radio   "O&ff", 8, 015 110 145 015
  radio   "&Master", 9, 015 125 145 015
  radio   "M&istress", 10, 015 140 145 015

  text    "&Description tag:", 11, 10, 165, 200, 15
  edit    "", 12, 10, 180, 200, 20

  button  "&Help", 100, 110 220 050 020
  button  "Ok", 1, 160 220 050 020, ok, default
}


on 1:dialog:k9opt:init:0:{
  turnon k9opt 2 %k9.splash . %k9.tbar . %k9.noslash . %k9.colinaction . %k9.statstart
  if (%k9.audio == Master) {
    did -c k9opt 9
  }
  else if (%k9.audio == Mistress) {
    did -c k9opt 10
  }
  else {
    did -c k9opt 8
  }
  set %k9.tbarbefore %k9.tbar
  did -o k9opt 12 1 %k9.versiontag
}

on 1:dialog:k9opt:sclick:100:k9helpd Options Options

on 1:dialog:k9opt:sclick:1:{
  set %k9.splash $getstate(k9opt,2)
  set %k9.tbar $getstate
  set %k9.noslash $getstate
  set %k9.colinaction $getstate
  set %k9.statstart $getstate

  if ($getstate(k9opt,8)) {
    set %k9.audio Off
  }
  else  if ($getstate(k9opt,9)) {
    set %k9.audio Master
  }
  else  if ($getstate(k9opt,10)) {
    set %k9.audio Mistress
  }
  if (%k9.tbar) {
    tbservnick
  }
  else if (%k9.tbarbefore) {
    titlebar
  }
  unset %k9.tbarbefore
  set %k9.versiontag $did(k9opt,12,1)
  updatestatwindow
  dialog -v k9settings
}

alias k9optd {
  redialog -m k9opt k9opt
}

; --[ Main setup dialog ]--------------------

dialog k9settings {
  title "K9 Settings"
  size   -1 -1 340 220

  icon     50, 10 10 32 32

  text     "", 51, 50 10 290 15
  text     "Copyright 1999 Nathan Roberts", 52, 50 25 290 15

  button  "&Channel Guarding" 2, 10 50 100 20
  button  "&Flood Protection" 3, 120 50 100 20
  button  "&Nick Management" 4, 230 50 100 20

  button  "&Away System" 5, 10 80 100 20
  button  "&Quit System" 6, 120 80 100 20
  button  "Auto&kick System" 7, 230 80 100 20

  button  "&Pervert Checker" 8, 10 110 100 20
  button  "&Bad Word Checker" 9, 120 110 100 20
  button  "&IRC Pager" 10, 230 110 100 20

  button  "&Sound Harvester" 11, 10 140 100 20
  button  "&Event Sounds" 12, 120 140 100 20
  button  "Pin&g Responses" 13, 230 140 100 20

  button  "&Options" 14, 120 170 100 20

  button  "&Help" 100, 240 200 50 020
  button  "Ok" 1, 290 200 50 020,default,ok
}

on 1:dialog:k9settings:sclick:50:master

on 1:dialog:k9settings:sclick:100:k9helpd Main K9 Setup

on 1:dialog:k9settings:init:0:{
  did -a k9settings 51 K9 Mk. II $k9versionno
  if ($exists($scriptdirk9.ico)) did -g k9settings 50 $scriptdirk9.ico
}

on 1:dialog:k9settings:sclick:2:k9guardd
on 1:dialog:k9settings:sclick:3:k9floodd
on 1:dialog:k9settings:sclick:4:k9nickd
on 1:dialog:k9settings:sclick:5:k9awayd
on 1:dialog:k9settings:sclick:6:k9quitd
on 1:dialog:k9settings:sclick:7:k9akickd
on 1:dialog:k9settings:sclick:8:k9pervd
on 1:dialog:k9settings:sclick:9:k9badwordd
on 1:dialog:k9settings:sclick:10:k9pagerd
on 1:dialog:k9settings:sclick:11:k9soundd
on 1:dialog:k9settings:sclick:12:k9eventsoundd
on 1:dialog:k9settings:sclick:13:k9pingd
on 1:dialog:k9settings:sclick:14:k9optd

alias k9setd {
  redialog -m k9settings k9settings
}

alias spt {
  .timer -m 1 1 $1-
}
