; K9 Mk. II: A protection and convienience script for mIRC
; Copyright (C) 1999  Nathan Roberts
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;
; To contact the author, send EMail to nathanr@crl.com, or see the web
; page at http://www.crl.com/~nathanr/k9.html

; K9 Channel Help Module
; ***************************
; This module contains the help system

dialog k9help {
  title "K9 Help"
  size   -1 -1 500 300

  button  "Ok",                           1, 450 280 050 020, ok, default

  edit    "",                             9, 000 000 500 280, multi, vsbar, autovs

}

on 1:dialog:k9help:init:0:{
  dialog -t k9help K9 Help: %k9.helptitle
  loadbuf -ot $+ %k9.helpsection k9help 9 $scriptdirk9help.txt
}

alias k9helpd {
  set %k9.helpsection $1
  set %k9.helptitle $2-
  redialog -m k9help k9help
}


; -----------------
; -- Help window --
; -----------------

alias k9helpcon {
  k9helpwin
}

alias k9help {
  k9helpwin
}

alias k9helpwin {
  k9helpd Main
}

#servhelp on

; -- Chanserv help --

on ^1:notice:*Chanserv Help*:*:{
  if ($left($1,1) != *) return
  if ($nick == chanserv) {
    if ($dialog(k9cshelp) == $null) redialog -m k9cshelp k9help
    dialog -t k9cshelp ChanServ Help
    set %k9.getshelp 1
    halt
  }
}

on ^1:notice:*Nickserv Help*:*:{
  if ($left($1,1) != *) return
  if ($nick == nickserv) {
    if ($dialog(k9cshelp) == $null) redialog -m k9cshelp k9help
    dialog -t k9cshelp NickServ Help
    set %k9.getshelp 1
    halt
  }
}

on ^1:notice:*End of Help*:*:{
  if ($nick == chanserv || $nick == nickserv) {
    unset %k9.getshelp
    halt
  }
}

on ^1:notice:*:*:{
  if ($nick == chanserv || $nick == nickserv) {
    if (%k9.getshelp && $dialog(k9cshelp) != $null) {
      did -a k9cshelp 9 $strip($1-) $crlf
      halt
    }
  }
}

#servhelp end
