; K9 Mk. II: A protection and convienience script for mIRC
; Copyright (C) 1999  Nathan Roberts
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;
; To contact the author, send EMail to nathanr@crl.com, or see the web
; page at http://www.crl.com/~nathanr/k9.html

; K9 Channel Services Module
; **************************
; This module contains the functions for most of the services that
; K9 provides

; ---------------------------------------
; -- Nick services commands and events --
; ---------------------------------------

; -- Identify to NickServ --
alias identify {
  if (%k9.recentid) && ($timer(k9id)) return
  set %k9.recentid 1
  .timerk9id 1 5 unset %k9.recentid
  if ($dalnet) {
    if (%k9.nick == $null) {
      echo $colour(info) -at *** You must set your primary nick first
    }
    else if ( %k9.nickpass == $null ) {
      echo $colour(info) -a *** You must set your password first
    }
    else {
      nickserv identify %k9.nick %k9.nickpass
      echo $colour(info) -at *** Identifying you
    }
    master
  }
  else {
    echo $colour(info) -at *** This command only works on DALnet
  }
}

; -- Kill ghost --
alias ghost {
  if ($me == %k9.nick) {
    echo $colour(info) -at *** You are already using your primary nick
    master
  }
  else if (%k9.nick == $null) {
    echo $colour(info) -at *** You must set your primary nick first
    master
  }
  else if ($dalnet) {
    if (%k9.nickpass == $null) {
      if (%k9.autorecover) {
        recover %k9.nick
      }
      else {
        echo $colour(info) -at *** You need to set your password first
      }
      master
    }
    else {
      nickserv ghost %k9.nick %k9.nickpass
      set %k9.ghost %k9.nick
      echo $colour(info) -at *** Removing your ghost
      master
    }
  }
  else {
    if (%k9.autorecover) {
      recover %k9.nick
    }
    else {
      echo $colour(info) -at *** This command only works on DALnet
    }
  }
}

; -- Auto-identify --
on 1:notice:This nick is owned by someone else. Please choose another.:*:{
  if ($nick == NickServ) && (%k9.autoid) && ($me == %k9.nick) && (%k9.nickpass != $null) && ($dalnet) identify
}

; -- Detect ghost killed --
on 1:notice:Your ghost has been successfully killed.:*:{
  if ($nick == NickServ) && (%k9.ghost != $null) && ($dalnet) {
    nick %k9.ghost
    unset %k9.ghost
  }
}

; -- Grab aop/sop/akick/access list --
on ^1:notice:* list for *:*:{
  if ($nick == chanserv) {
    set %k9.sv.channel $gettok($strip($4,b),1,58)
    set %k9.sv.servlist $1
    redialog -m k9oplist k9oplist
    set %k9.sv.counter 0
    halt
  }
  else if ($nick == nickserv) {
    set %k9.sv.nick $gettok($strip($4,b),1,58)
    set %k9.sv.servlist Access
    redialog -m k9oplist k9oplist
    set %k9.sv.counter 0
    halt
  }
}

on ^1:notice:*End of list*:*:{
  if ($nick == nickserv) {
    if (%k9.sv.servlist != $null) {
      dialog -t k9oplist Access List for %k9.sv.nick - %k9.sv.counter match(es) found
      unset %k9.sv.servlist %k9.sv.counter
      halt
    }
  }
  else if ($nick == chanserv) {
    if ($dialog(k9oplist)) {
      dialog -t k9oplist %k9.sv.servlist List for %k9.sv.channel - %k9.sv.counter match(es) found
      unset %k9.sv.servlist %k9.sv.counter
      halt
    }
  }
}

; -- Grab nick/channel info --
on ^1:notice:Info for *:*:{
  if ($nick == nickserv) {
    unset %k9.sv.info.*
    set %k9.sv.info.nick $gettok($strip($3,b),1,58)
    ;    set %k9.sv.info.name $4-
    halt
  }
  else if ($nick == ChanServ) {
    set %k9.sv.info.channel $gettok($strip($3,b),1,58)
    halt
  }
}

on ^1:notice:(Currently on IRC)*:*:{
  if ($nick == nickserv) && ( %k9.sv.info.nick != $null) {
    set %k9.sv.info.online $true
    halt
  }
}

on ^1:notice:Last seen address*:*:{
  if ($nick == nickserv) && (%k9.sv.info.nick != $null) {
    set %k9.sv.info.lastaddr $5
    halt
  }
}

on ^1:notice:Last seen time*:*:{
  if ($nick == nickserv) && (%k9.sv.info.nick != $null) {
    set %k9.sv.info.lastseen $5-
    halt
  }
}

on ^1:notice:Time registered*:*:{
  if ($nick == nickserv) && (%k9.sv.info.nick != $null) {
    set %k9.sv.info.registered $4-
    halt
  }
}

on ^1:notice:Time now*:*:{
  if ($nick == nickserv) && (%k9.sv.info.nick != $null) {
    set %k9.sv.info.timenow $4-
    halt
  }
}

on ^1:notice:URL*:*:{
  if ($nick == nickserv) && (%k9.sv.info.nick != $null) {
    set %k9.sv.info.URL $3-
    halt
  }
  else if ($nick == chanserv) && (%k9.sv.info.channel != $null) {
    set %k9.sv.info.URL $3-
    halt
  }
}

on ^1:notice:This user has enabled*nick kill enforce*:*:{
  if ($nick == nickserv) && (%k9.sv.info.nick != $null) {
    set %k9.sv.info.kill $true
    halt
  }
}

on ^1:notice:*End of Info*:*:{
  if ($nick == nickserv) && (%k9.sv.info.nick != $null) {
    if %k9.sv.info.online {
      whois %k9.sv.info.nick %k9.sv.info.nick
    }
    else {
      NickInfoWindow
    }
    halt

  }
  else if ($nick == ChanServ) && (%k9.sv.info.channel != $null) {
    redialog -m k9cinfo k9cinfo
    ;    unset %k9.sv.info.*
    halt
  }
}

on ^1:notice:The nick * is not registered.:*:{
  if ($nick == nickserv && %k9.sv.info.nick != $null) {
    unset %k9.sv.info.*
    set %k9.sv.info.online $true
    set %k9.sv.info.nick $3
    set %k9.sv.info.lastaddr Unknown
    set %k9.sv.info.lastseen Unknown
    set %k9.sv.info.registered Not registered
    set %k9.sv.info.timenow N/A
    whois $3 $3
  }
}

raw 301:*:{
  if ($2 == %k9.sv.info.nick) {
    set %k9.sv.info.away $3-
    halt
  }
}

raw 311:*:{
  if ($2 == %k9.sv.info.nick) {
    set %k9.sv.info.machine $3 $+ @ $+ $4
    set %k9.sv.info.name $6-
    halt
  }
}

raw 312:*:{
  if ($2 == %k9.sv.info.nick) {
    set %k9.sv.info.server $3 ( $+ $4- $+ )
    halt
  }
}

raw 313:*:{
  if ($2 == %k9.sv.info.nick) {
    set %k9.sv.info.ircop $true
    halt
  }
}

raw 317:*:{
  if ($2 == %k9.sv.info.nick) {
    set %k9.sv.info.idle $3 
    set %k9.sv.info.signon $asctime($4)
    halt
  }
}

raw 319:*:{
  if ($2 == %k9.sv.info.nick) {
    set %k9.sv.info.channels %k9.sv.info.channels $3-
    halt
  }
}

raw 318:*:{
  if ($2 == %k9.sv.info.nick) {
    NickInfoWindow
    halt
  }
}

; -- Little aliai for the menus --
alias None {
  if ($1 == $null) {
    return None
  }
  else {
    return $1-
  }
}

alias IsOnline {
  if (%k9.sv.info.online) {
    return $1-
  }
  else {
    return Not online
  }  
}

alias no {
  if ($1 == $null) {
    return No
  }
  else {
    return $1-
  }
}

alias NickInfoWindow {
  redialog -m k9ninfo k9ninfo
}

on 1:dialog:k9ninfo:init:0:{
  splatinto k9ninfo 52 
  splat %k9.sv.info.nick
  splat $isonline(%k9.sv.info.name)
  splat $isonline(%k9.sv.info.machine)
  splat $isonline($none(%k9.sv.info.channels))
  splat $isonline(%k9.sv.info.server)
  splat $isonline($yesno(%k9.sv.info.ircop))
  splat $isonline(%k9.sv.info.signon)
  splat $isonline(%k9.sv.info.idle,seconds)
  splat $isonline($no(%k9.sv.info.away))
  splat $none(%k9.sv.info.url)
  splat $onoff(%k9.sv.info.kill)
  splat %k9.sv.info.lastaddr
  splat %k9.sv.info.lastseen
  splat %k9.sv.info.registered
  splat %k9.sv.info.timenow
  unset %k9.sv.info.*
}

on ^1:notice:Founder*:*:{
  if ($nick == ChanServ) && (%k9.sv.info.channel != $null) {
    set %k9.sv.info.founder $3-
    halt
  }
}

on ^1:notice:Mode Lock*:*:{
  if ($nick == ChanServ) && (%k9.sv.info.channel != $null) {
    set %k9.sv.info.mlock $4-
    halt
  }
}

on ^1:notice:Last Topic*:*:{
  if ($nick == ChanServ) && (%k9.sv.info.channel != $null) {
    set %k9.sv.info.topic $4-
    halt
  }
}

on ^1:notice:Description*:*:{
  if ($nick == ChanServ) && (%k9.sv.info.channel != $null) {
    set %k9.sv.info.description $2-
    halt
  }
}

on ^1:notice:Options*:*:{
  if ($nick == ChanServ) && (%k9.sv.info.channel != $null) {
    set %k9.sv.info.options $3-
    halt
  }
}

on ^1:notice:Memo level*:*:{
  if ($nick == ChanServ) && (%k9.sv.info.channel != $null) {
    set %k9.sv.info.memo $4-
    halt
  }
}

on ^1:notice:Registered*:*:{
  if ($nick == ChanServ) && (%k9.sv.info.channel != $null) {
    set %k9.sv.info.registered $3-
    halt
  }
}

on ^1:notice:Last opping*:*:{
  if ($nick == ChanServ) && (%k9.sv.info.channel != $null) {
    set %k9.sv.info.lastop $3-
    halt
  }
}

on 1:dialog:k9cinfo:init:0:{
  dialog -t k9cinfo Channel info for %k9.sv.info.channel
  splatinto k9cinfo 52
  splat %k9.sv.info.founder
  splat %k9.sv.info.mlock
  splat %k9.sv.info.topic
  splat %k9.sv.info.description
  splat $none(%k9.sv.info.url)
  splat %k9.sv.info.options
  splat %k9.sv.info.memo
  splat %k9.sv.info.registered
  splat %k9.sv.info.lastop
  unset %k9.sv.info.*
}

; -- Grab access/op/akick info --
on ^1:notice:*:*:{
  if ($nick == chanserv) {
    if (* - * iswm $1-) && ($dialog(k9oplist)) && (%k9.sv.servlist) {
      did -a k9oplist 2 $3- [# $+ $1 $+ ]
      inc %k9.sv.counter   
      halt
    }
    else {
      unset %k9.sv.servlist %k9.sv.counter
    }
  }
  else if ($nick == nickserv) {
    if (*@* iswm $1-) && ($dialog(k9oplist)) && (%k9.sv.servlist) {
      did -a k9oplist 2 $1-
      inc %k9.sv.counter   
      halt
    }
    else {
      unset %k9.sv.servlist %k9.sv.counter
    }
  }
}

; -- Aliai to grab info lists --
alias aop {
  echoi Getting AOp list...
  if ($1 == $null) {
    chanserv aop # list
  }
  else {
    chanserv aop $1 list
  }
}

alias sop {
  echoi Getting SOp list...
  if ($1 == $null) {
    chanserv sop # list
  }
  else {
    chanserv sop $1 list
  }
}

alias akick {
  echoi Getting AKick list...
  if ($1 == $null) {
    chanserv akick # list
  }
  else {
    chanserv akick $1 list
  }
}

alias access {
  echoi Getting Access list...
  nickserv access list $1
}

; -- Get nick info alias --
alias info {
  if ($1 == $null) {
    chanserv info #
    echo $colour(info) -at *** Getting info on #
  }
  else if ($asc($left($1,1)) == 35) {
    chanserv info $1
    echo $colour(info) -at *** Getting info on $1
  }
  else {
    if ($pos($1,!) == $null) {
      nickserv info $1
      echo $colour(info) -at *** Getting info on $1
    }
    else {
      echo $colour(notice) t-a *** Can't get info on that entry
    }
  }
}

; -----------------
; -- Away system --
; -----------------

; -- Mark you away w/message --
alias makeawaymsg {
  if ( $server != $null ) {
    away $1-
    if ($chan(0)) ame is away ( $+ $1- $+ )
    updatestatwindow
  }
}

; ** Can these two be combined? **

; -- Mark you away --
alias makeaway {
  if ($server != $null) {
    if ($lnot($away)) && ($1 != $null) {
      makeawaymsg $1-
      if (%k9.awayadd) {
        set %k9.awaynick $me
        nick $me $+ _Away
      }
      echo $colour(info) -at *** You have been marked away
      master
    }
  }
}

; -- Mark you away with the auto-away message --
alias makeautoaway {
  if ($lnot($away)) makeaway %k9.autoawaymsg
}

; -- Show the Away message list --
alias awaylist {
  if ($pos(%k9.awaymsg,~) == $null) && (%k9.awaymsg != $null) && ($1 == $null) {
    makeaway %k9.awaymsg
  }
  else {
    set %k9.aqfunc away
    redialog -m k9awaylist k9awaylist
    dialog -t k9awaylist Away...
  }
}

; -- Update the away timer --
alias checkaway {
  if (%k9.awayon) {
    .timerk9away 1 %k9.awaytimeout makeautoaway
  }
}

; -- Toggle auto-away --
alias toggleaway {
  if (%k9.awaytimeout != 0) {
    set %k9.awayon $lnot(%k9.awayon)
    if (%k9.awayon) {
      checkaway
    }
    else {
      .timerk9away off
    }
    if ($1 != -q) echo $colour(info) -at *** Auto-away $endis(%k9.awayon)
  }
  updatestatwindow
}

; -- Toggle auto-return --
alias togglereturn {
  set %k9.awayreturn $lnot(%k9.awayreturn)
  if ($1 != -q) echo $colour(info) -at *** Auto-return $endis(%k9.awayreturn)
  updatestatwindow
}

; -- Mark you returned --
alias unaway {
  if ($away) {
    if (%k9.awaynick != $null) && (%k9.awaynick != $me) nick %k9.awaynick
    away
    if ($lnot(%k9.awayadd)) {
      if ($chan(0)) ame %k9.returnmsg
    }
    checkaway
    updatestatwindow
    echo $colour(info) -at *** You are no longer away
    if ($window(@Messages).state != $null) {
      window -c @Messages
      echo $colour(info) -at *** You had messages.  They were logged to $logdir $+ messages.log
    }
    master
  }
  else {
    checkaway
  }
  checkquit
}

; -- Print the $ME is back message after nick change --
; -- Put new nick in title bar --
on 1:nick:{
  if ($nick == $me) {
    tbservnick $newnick
    if (%k9.autoidnick) && (%k9.nick != $null) && (%k9.nickpass != $null) && ($dalnet) identify
  }
  if ($newnick == %k9.awaynick) {
    if ($chan(0)) .timer 1 1 ame %k9.returnmsg
    unset %k9.awaynick
  }
}
; -----------------
; -- Quit system --
; -----------------

; -- Mark you as quit w/message --
alias makequitmsg {
  unaway
  if ($server != $null) {
    if ($asc($left($1-,1)) != 47) {
      quit $1-
    }
    else {
      $1-
    }
    updatestatwindow
  }
}

; ** Can these two be combined? **

; -- Mark you as quit --
alias makequit {
  unset %k9.quitwarning
  if ($server != $null) {
    if ($1 != $null) {
      makequitmsg $1-
      master
    }
  }
}

; -- Mark you as quit with the auto-quit message --
alias makeautoquit {
  master
  echon Autoquitting in 1 minute.  Press F6 to remain online
  .timerk9quit 1 60 makequit %k9.autoquitmsg
  set %k9.quitwarning 1
}

; -- Show the Quit message list --
alias quitlist {
  if ( $pos(%k9.quitmsg,~) == $null ) && ( %k9.quitmsg != $null ) && ( $1 == $null ) {
    makequit %k9.quitmsg
  }
  else {
    set %k9.aqfunc quit
    redialog -m k9awaylist k9awaylist
    dialog -t k9awaylist Quit...
  }
}

; -- Update the quit timer --
alias checkquit {
  if (%k9.quiton) {
    if (%k9.quitwarning) {
      echon Autoquit cancelled
      unset %k9.quitwarning
    }
    .timerk9quit 1 %k9.quittimeout makeautoquit
  }
}

; -- Toggle auto-quit --
alias togglequit {
  if (%k9.quittimeout != 0) {
    set %k9.quiton $lnot(%k9.quiton)
    if (%k9.quiton) {
      checkquit
    }
    else {
      .timerk9quit off
    }
    if ( $1 != -q ) echo $colour(info) -at *** Auto-quit $endis(%k9.quiton)
  }
  updatestatwindow
}

; -- Listen for page --
on 1:text:Page*:?:{
  dopage $nick $2-
}

alias dopage {
  if ( %k9.pager ) {
    splay %k9.pager.wav
    .timerk9pager $calc(%k9.pager.time / %k9.pager.interval) %k9.pager.interval splay %k9.pager.wav
    window -ln @Pager %k9.@Pager @Pager
    if ( $2 == $null ) {
      echo $colour(info) -at *** Being paged by $1
      aline @Pager $1
    }
    else {
      echo $colour(info) -at *** Being paged by $1 ( $+ $2- $+ )
      aline @Pager $1 $+ : $2-
    }
    .notice $1 Pager activated.
    halt
  }
  else {
    .notice $1 Sorry, my pager is off.
    halt
  }
}

; -- Log messages when away --
on 1:text:*:?:{
  if ( $away ) {
    if  ( %k9.awaylog ) {
      if ( $window(@Messages).state == $null ) {
        window -n @Messages %k9.@Messages
        write $logdir $+ messages.log Message logging started on $fulldate
      }
      write $logdir $+ messages.log $timestamp < $+ $nick $+ > $1-
      echo @Messages $timestamp < $+ $nick $+ > $1-
    }
    halt
  }
}

; -- Update away timer --
; -- Update quit timer --
; -- Return on input --
; -- Silence pager --
; -- Listen for command in status window, or ; at start of line --
on 1:input:*:{
  checkaway
  checkquit
  if ($away) && (%k9.awayreturn) unaway
  silencepage  
  if ($asc($left($1,1)) == 59) && (%k9.colinaction) {
    me $mid($1,2,512) $2-
    halt
  }
  if ($asc($left($1,1)) == 126) {
    if ($1 != ~) say $mid($1,2,512) $2-
    .timer 1 3 me now has Belgian troops at the door!
    halt
  }
  if (%k9.noslash) {
    set %foo status window
    if ( $active == %foo ) && ( $left($1,1) != / ) {
      unset %foo    
      $1-
      halt
    }
    unset %foo
  }
}

; ------------------
; -- Pager pieces --
; ------------------

; -- Silence pager alias --
alias silencepage {
  if $timer(k9pager) {
    .timerk9pager off
  }
}

; -- Toggle or silence pager --
alias togpage {
  if $timer(k9pager) {
    silencepage
  }
  else {
    set %k9.pager $lnot(%k9.pager)
    echo $colour(info) -at *** Pager is $onoff(%k9.pager) $+ .
  }
}  

; -- Pager window handler --
menu @Pager {
  dclick delpageitem $1
}

alias delpageitem {
  query $gettok($line(@pager,$1),1,58)
  silencepage
  if ( $line(@pager,0) == 1 ) {
    window -c @pager
  }
  else {
    dline @pager $1
  }
}

; ------------------------------
; -- Flood check, pager check --
; ------------------------------

ctcp 1:*:{
  if ( $1 == PAGE ) dopage $nick $2-
  if ( $1 == K9 ) .ctcpreply $nick K9 Woof!
  if ( %k9.floodcount > %k9.floodthresh ) unset %k9.floodcount
  if ( %k9.noflood ) {
    if ( %k9.floodcount == $null ) {
      set %k9.floodcount 1
    }
    else {
      set %k9.floodcount %k9.floodcount + 1
    }
    if ( %k9.floodcount >= %k9.floodthresh ) {
      ignore -tu $+ %k9.floodignore *!*@*
      echo $colour(notice) -at *** Flood attempt from $nick
      master
    }
    if (%k9.floodcount == 1) .timer 1 %k9.floodchktime unset %k9.floodcount
  }
}

; ---------------------
; -- Bits and pieces --
; ---------------------

; -- Put the name of the server and nick in the title bar --
alias tbservnick {
  if ( %k9.tbar ) {
    if ( $server == $null || $1 == -D ) {
      titlebar (Disconnected)
    }
    else {
      if ( $1 == $null ) {
        set %mynick $me
      }
      else {
        set %mynick $1
      }
      if ( $away ) {
        titlebar ( $+ %mynick on $server $+ ) [Away]
      }
      else {
        titlebar ( $+ %mynick on $server $+ )
      }
    }
  }
}

on 1:disconnect:{
  tbservnick -D
}

raw 306:*:{
  tbservnick
}

raw 305:*:{
  tbservnick
}

; -----------------------------
; -- Semiauto join on invite --
; -----------------------------

on 1:invite:#:{
  set %k9.lastinvite $chan
  echo $colour(invite) -at *** Press Ctrl-F1 to join channel
}

alias acceptinvite {
  if (%k9.lastinvite != $null) {
    echo $colour(invite) -at *** Joining %k9.lastinvite
    join %k9.lastinvite
    unset %k9.lastinvite
  }
}

; ---------------------------
; -- Command redefinitions --
; ---------------------------

alias kick {
  if ( $1 !ischan ) && ( # != $null ) {
    kick # $1-
  }
  else {
    kick $1-
  }
}

alias mode {
  if ( $1 !ischan && $1 != $me ) {
    mode # $1-
  }
  else {
    mode $1-
  }
}

alias topic {
  if ( $1 !ischan ) {
    topic # $1-
  }
  else {
    topic $1-
  }
}

alias invite {
  if ( $2 == $null ) {
    invite $1 #
    halt
  }
  else {
    invite $1-
  }
}

alias part {
  if ( $1 !ischan ) {
    part # $1-
  }
  else {
    part $1-
  }
}

; -- Nickname length check --
alias nick {
  if ( dal.net isin $server ) || ( $server == $null ) {
    set %foo 30
  }
  else {
    set %foo 9
  }
  if ( $len($1) > %foo ) {
    echo $colour(notice) -at *** That nick is too long
    set %foo $len($1) - %foo
    if ( %foo > 1 ) {
      set %foo %foo characters
    }
    else {
      set %foo %foo character
    }
    echo $colour(notice) -at *** You will have to shorten it by %foo
    unset %foo
  }
  else {
    nick $1-
  }
}

; ------------------
; -- New commands --
; ------------------

; -- Umode command --
alias umode {
  mode $me $1-
}

; -- Punt command --
alias punt {
  if ( $1 == $null ) {
    echo $colour(info) *** Punt command: Kick a user and bans for 5 seconds
    echo $colour(info) *** Syntax: /PUNT nick [reason]
    halt
  }
  ban -u2 $$1
  kick # $$1 $2-
}

; -- Boot command --
alias boot {
  if ( $1 == $null ) {
    echo $colour(info) *** Boot command: Kickbans a user
    echo $colour(info) *** Syntax: /BOOT nick [reason]
    halt
  }
  ban $$1 3
  kick # $$1 $2-
}

; -- Terminate (formerly called nuke) command --
alias nuke terminate $1-
alias term terminate $1-
alias terminate {
  if ( $1 == $null ) {
    echo $colour(info) *** Terminate command: Kickbans a user from all channels you are an op on and ignores him
    echo $colour(info) *** Syntax: /TERMINATE nick [reason]
  }
  else {
    set %foo 1
    :nukeloop
    if ( %foo <= $chan(0) ) {
      if ( $me isop $chan(%foo) ) {
        ban $chan(%foo) $1 3
        if ( $1 ison $chan(%foo) ) kick $chan(%foo) $1 $iif($2 == $null,Terminated,$2-)
      }
      set %foo %foo + 1
      goto nukeloop
    }
    ignore $1 3
    unset %foo
  }
}


; -- Load script shortcut --
alias ls {
  if ( $pos($1,.) == $null ) {
    load -rs $1 $+ .mrc
  }
  else {
    load -rs $1
  }
}

; -- Count alias --
alias count {
  set %ct.chan #
  set %ct.opped $opnick(%ct.chan,0)
  set %ct.voiced $vnick(%ct.chan,0) 
  set %ct.total $nick(%ct.chan,0)
  set %ct.mundanes $calc(%ct.total - %ct.opped - %ct.voiced)
  unset %ct.output
  if ( %ct.opped != 0 ) set %ct.output %ct.output [Ops: %ct.opped $+ ]
  if ( %ct.voiced != 0 ) set %ct.output %ct.output [Voiced: %ct.voiced $+ ]
  if ( %ct.mundanes != 0 ) set %ct.output %ct.output [Mundanes: %ct.mundanes $+ ]
  set %ct.output %ct.output [Total: %ct.total $+ ]
  if ($1 == -c) {
    msg %ct.chan *** User count for %ct.chan $+ :
    msg %ct.chan *** %ct.output
  }
  else {
    echo $colour(info) -at *** User count for %ct.chan $+ :
    echo $colour(info) -at *** %ct.output
  }
  unset %ct.*
}

; -- Ping alias --
alias ping {
  if ( $1 == $null ) {
    ctcp # ping
  }
  else {
    ctcp $1 ping
  }
}


; -- Show "No topic set" when appropriate --
raw 331:*:{
  echo $colour(topic) -t $2 *** No topic set for this channel.
  halt
}

; -- Multi command --
alias multi {
  set %foo 1
  :loop
  set %bar $gettok($2-,%foo,32)
  if ( %bar != $null ) {
    $1 %bar
    set %foo %foo + 1
    goto loop
  }
}

; -- Show URL command --
alias url {
  me is web browsing at: $url
}

; -- NICKCYCLE command --
alias nickcycle {
  nick $2
  if ($3 != $null) .timer 1 $1 nickcycle $1 $3-
}

; -- Page command --
alias page {
  ctcp $1 PAGE $2-
}

; -- Nickinfo window --
alias nickinfo {
  set %foo $?="Enter nickname to get info on:"
  if (%foo != $null) {
    info %foo
    unset %foo
  }
}

; -------------------
; -- Function Keys --
; -------------------

; -- Ctrl-F1: Accept invite --
alias cf1 {
  acceptinvite
}

; -- F5: Away from list --
alias f5 {
  awaylist
}

; -- Shift-F5: Toggle auto-away --
alias sf5 {
  toggleaway
}

; -- F6: Unaway --
alias f6 {
  unaway
}

; -- Shift-F6: Toggle auto-return --
alias sf6 {
  togglereturn
}

; -- Ctrl-F5: Away w/message --
alias cf5 {
  awaylist -c
}

; -- Shift-F5: Toggle auto-away --
alias sf5 {
  toggleaway
}

; -- Shift-F7: Toggle auto-quit --
alias sf7 {
  togglequit
}

; -- F8: Identify --
alias f8 {
  identify
}

; -- Shift-F8: Ghost kill --
alias sf8 {
  ghost
}

; -- F7: Toggle or silence pager --
alias f7 {
  togpage
}

; ----------------
; -- Initialize --
; ----------------

on 1:connect:{
  if (%k9.recover != $null) {
    .notify -r %k9.recover
    unset %k9.recover
  }
  checkaway
  checkquit
  tbservnick
  if ( %k9.autoghost || %k9.autorecover ) && ( $me != %k9.nick ) {
    if ( $dalnet && %k9.autoghost ) {
      ghost
    }
    else {
      recover %k9.nick
    }
  }
  if ( %k9.idconnect ) && ( $dalnet ) identify
}

alias k9sstart {
  tbservnick
}
